﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business.Utilities;

public partial class ReportScreeningStationSummary : System.Web.UI.Page
{
    List<ReportParameter> _reportParameters = new List<ReportParameter>();
    private UserAccountManager _currentUser;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (AccessAllowed())
        {
            if (!Page.IsPostBack)
            {
                Session["ReportYear"] = "09";
                Session["ReportMonth"] = "August";

                SetReportParameters();
                SetDropDownListVisnId();
                ReportViewer1.Visible = false;
            }

            if (
                (DropDownListVisnID.SelectedIndex == 0) ||
                (DropDownListFacility.SelectedIndex == 0)
                )
            {
                ButtonRunReport.Enabled = false;
            }
            else
                ButtonRunReport.Enabled = true;

            ReportViewer1.Visible = false;
        }
        else
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        UserAccountManager _currentUser1 = (UserAccountManager)HttpContext.Current.User;
        
        if (DropDownListVisnID.SelectedIndex > 0 &&
                DropDownListFacility.SelectedIndex > 0)
        {
            string userId = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
            ReportParameter reportParam = new ReportParameter("UserId", userId);
            ReportParameter reportParamVisn = new ReportParameter("VisnID", DropDownListVisnID.SelectedValue); //"VISN 7");
            ReportParameter reportParamFacility = new ReportParameter("FacilityID", DropDownListFacility.SelectedValue); //"508");
            ReportParameter reportParamYearTo = new ReportParameter("YearTo", Session["ReportYear"].ToString()); // "09");
            ReportParameter reportParamMonthTo = new ReportParameter("MonthTo", Session["ReportMonth"].ToString()); //"August");
            ReportParameter reportParamUsername = new ReportParameter("Username", _currentUser1.FullName);
            
            //ReportViewer1.ServerReport.DisplayName = "What";
            
            ReportViewer1.Reset();

            _reportParameters.Clear();
            _reportParameters.Add(reportParam);
            _reportParameters.Add(reportParamVisn);
            _reportParameters.Add(reportParamFacility);
            _reportParameters.Add(reportParamYearTo);
            _reportParameters.Add(reportParamMonthTo);
            _reportParameters.Add(reportParamUsername);

            ReportViewer1.ServerReport.ReportPath = "ReportScreeningStationSummary";

            //var config = RegistriesConfigurations.GetConfig();

            ReportViewer1.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));
            //ReportViewer1.ServerReport.ReportServerUrl = new Uri(config.ReportingServer);
            if (ReportViewer1.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
            //if (ReportViewer1.ServerReport.ReportPath.IndexOf(config.BaseReportPath, 0) == -1)
            {
                ReportViewer1.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewer1.ServerReport.ReportPath;
                //ReportViewer1.ServerReport.ReportPath = config.BaseReportPath + ReportViewer1.ServerReport.ReportPath;
            }

            //ReportViewer1.LocalReport.SetParameters(_reportParameters.ToArray());
            ReportViewer1.ServerReport.SetParameters(_reportParameters.ToArray());

            ReportViewer1.ProcessingMode = ProcessingMode.Remote;

            //ReportViewer1.DataBind();
            ReportViewer1.Visible = true;
            //ReportViewer1.LocalReport.Refresh();
            ReportViewer1.ServerReport.Refresh();


        }
        else
        {
            ReportViewer1.Visible = false;
        }
    }
    protected void DropDownListVisnID_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (DropDownListVisnID.SelectedIndex != 0)
        {
            SetDropDownListFacility();
            ButtonRunReport.Enabled = false;
            ReportViewer1.Visible = false;
        }
        else
        {
            DropDownListFacility.Items.Clear();
        }
    }
    protected void ObjectDataSourcePermittedVISNs_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        e.InputParameters["userName"] = HttpContext.Current.User.Identity.Name.ToLower();
    }
    protected void ObjectDataSourcePermittedStations_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        e.InputParameters["userName"] = HttpContext.Current.User.Identity.Name.ToLower();
    }
    private void SetDropDownListVisnId()
    {
        if ( !_currentUser.IsInRole(16) )
        {
            DropDownListVisnID.DataSource = ObjectDataSourcePermittedStationVISNs;
            DropDownListVisnID.DataBind();
            DropDownListVisnID.Items.Insert(0, new ListItem("Select One", "000"));
        }
    }
    private void SetDropDownListFacility()
    {
        DropDownListFacilityDiv1.Visible = true;
        DropDownListFacilityDiv2.Visible = true;

        if (!_currentUser.IsInRole(18))
        {
            DropDownListFacility.DataSource = ObjectDataSource9;
        }
        else
        {
            DropDownListFacility.DataSource = ObjectDataSourcePermittedStations;
        }

        DropDownListFacility.DataBind();
        DropDownListFacility.Items.Insert(0, new ListItem("Select One", "000"));
        DropDownListFacility.SelectedIndex = 0;
    }
    private void SetReportParameters()
    {
        //string userId = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
        //ReportParameter reportParam = new ReportParameter("UserId", userId);
        //_reportParameters.Add(reportParam);
        //ReportViewer1.LocalReport.SetParameters(_reportParameters.ToArray());



    }
    private bool AccessAllowed()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        return (_currentUser.IsInRole(16) || _currentUser.IsInRole(17) || _currentUser.IsInRole(18));
    }
}
