﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessManager;

public partial class InitialScreeningNationalSummary : System.Web.UI.Page
{
    private UserAccountManager _currentUser;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (AccessAllowed())
        {
            if (!Page.IsPostBack)
            {
                Session["ReportYear"] = "09";
                Session["ReportMonth"] = "August";
                ReportViewer1.Visible = false;
                SetDropDownListVisnIdForVisnUser();
            }

            if (DropDownListVisnID.SelectedIndex == 0)
            {
                btnRunReport.Enabled = false;
            }
            else
                btnRunReport.Enabled = true;

            //SetReportParameters();

            ReportViewer1.Visible = false;
        }
        else
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        //ObjectDataSource1.Select();
        //ObjectDataSource1.DataBind();
        //ReportViewer1.DataBind();
        //ReportViewer1.Visible = true;
        //ReportViewer1.LocalReport.Refresh();
        
        ReportViewer1.Reset();

        ReportViewer1.ServerReport.ReportPath = "ReportScreenVISNSummary";

        //var config = RegistriesConfigurations.GetConfig();

        ReportViewer1.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));
        //ReportViewer1.ServerReport.ReportServerUrl = new Uri(config.ReportingServer);
        if (ReportViewer1.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
        //if (ReportViewer1.ServerReport.ReportPath.IndexOf(config.BaseReportPath, 0) == -1)
        {
            ReportViewer1.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewer1.ServerReport.ReportPath;
            //ReportViewer1.ServerReport.ReportPath = config.BaseReportPath + ReportViewer1.ServerReport.ReportPath;
        }
        //ReportParameter paramMonth = new ReportParameter("Month", (string)Session["ReportMonth"]);
        //ReportParameter paramYear = new ReportParameter("Year", (string)Session["ReportYear"]);
        ReportParameter paramUsername = new ReportParameter("Username", _currentUser.FullName);
        ReportParameter paramVisnId = new ReportParameter("VisnId", DropDownListVisnID.SelectedValue);

        //ReportViewer1.LocalReport.SetParameters(new ReportParameter[] { paramMonth, paramYear });
        //ReportViewer1.ServerReport.SetParameters(new ReportParameter[] { paramMonth, paramYear, paramUsername, paramVisnId });
        ReportViewer1.ServerReport.SetParameters(new ReportParameter[] { paramUsername, paramVisnId });

        ReportViewer1.ProcessingMode = ProcessingMode.Remote;
        ReportViewer1.Visible = true; 
        ReportViewer1.ServerReport.Refresh();
    }
    protected void ObjectDataSourcePermittedVISNs_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        e.InputParameters["userName"] = HttpContext.Current.User.Identity.Name.ToLower();
    }
    private bool AccessAllowed()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        return (_currentUser.IsInRole(16) || _currentUser.IsInRole(17));
    }
    private void SetDropDownListVisnIdForVisnUser()
    {
        if( !_currentUser.IsInRole(16))
        {
            DropDownListVisnID.DataSource = ObjectDataSourcePermittedVISNs;
            DropDownListVisnID.DataBind();
            DropDownListVisnID.Items.Insert(0, new ListItem("Select One", "000"));
        }
    }
}
