﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.Business.Utilities;  
using VeteransAffairs.Registries.BusinessManager;

public partial class ReportComprehensiveVisnSummary : System.Web.UI.Page
{
    private UserAccountManager _currentUser;
    List<ReportParameter> _reportParameters = new List<ReportParameter>();
    
    protected void Page_Load(object sender, EventArgs e)
    {
        if (AccessAllowed())
        {
            if (!IsPostBack)
            {
                ReportViewer1.Visible = false;
                SetDropDownListVisnIdForVisnUser();
            }

            if (DropDownListVisnID.SelectedIndex == 0) 
            {
                ButtonRunReport.Enabled = false;
            }
            else
                ButtonRunReport.Enabled = true;

            ReportViewer1.Visible = false;
        }
        else
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        string test1 = DropDownListVisnID.SelectedValue;
        //ObjectDataSource1.Select();
        //ObjectDataSource1.DataBind();
        //ReportViewer1.DataBind();
        //ReportViewer1.Visible = true;
        //ReportViewer1.LocalReport.Refresh();

        string userId = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
        UserAccountManager _currentUser1 = (UserAccountManager)HttpContext.Current.User;

        ReportParameter reportParamVisn = new ReportParameter("VisnId", DropDownListVisnID.SelectedValue);
        ReportParameter reportParamUsername = new ReportParameter("Username", _currentUser1.FullName);

        //ReportViewer1.ServerReport.DisplayName = "What";

        ReportViewer1.Reset();

        _reportParameters.Clear();
        _reportParameters.Add(reportParamVisn);
        _reportParameters.Add(reportParamUsername);

        //var config = RegistriesConfigurations.GetConfig();

        ReportViewer1.ServerReport.ReportPath = "ReportComprehensiveVisnSummary";

        ReportViewer1.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));
        //ReportViewer1.ServerReport.ReportServerUrl = new Uri(config.ReportingServer);
        if (ReportViewer1.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
        //if (ReportViewer1.ServerReport.ReportPath.IndexOf(config.BaseReportPath, 0) == -1)
        {
            ReportViewer1.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewer1.ServerReport.ReportPath;
            //ReportViewer1.ServerReport.ReportPath = config.BaseReportPath + ReportViewer1.ServerReport.ReportPath;
        }
        ReportViewer1.ServerReport.SetParameters(_reportParameters.ToArray());

        ReportViewer1.ProcessingMode = ProcessingMode.Remote;

        ReportViewer1.Visible = true;
        ReportViewer1.ServerReport.Refresh();

    }
    protected void ObjectDataSourcePermittedVISNs_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        e.InputParameters["userName"] = HttpContext.Current.User.Identity.Name.ToLower();
    }
    private void SetDropDownListVisnIdForVisnUser()
    {
        if (!_currentUser.IsInRole(16))
        {
            DropDownListVisnID.DataSource = ObjectDataSourcePermittedVISNs;
            DropDownListVisnID.DataBind();
            DropDownListVisnID.Items.Insert(0, new ListItem("Select One", "000"));
        }
    }
    private bool AccessAllowed()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        return (_currentUser.IsInRole(16) || _currentUser.IsInRole(17));
    }
}
