﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.Business.Utilities; 
using VeteransAffairs.Registries.BusinessManager;

public partial class ReportComprehensiveVhaSummary : System.Web.UI.Page
{
    List<ReportParameter> _reportParameters = new List<ReportParameter>();
    private UserAccountManager _currentUser;

    protected void Page_Load(object sender, EventArgs e)
    {
        if(AccessAllowed())
        {
            //string userId = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
            //ReportParameter reportParam = new ReportParameter("UserId", userId);
            //_reportParameters.Add(reportParam);
            //ReportViewer1.LocalReport.SetParameters(_reportParameters.ToArray());

            string userId = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
            UserAccountManager _currentUser1 = (UserAccountManager)HttpContext.Current.User;

            ReportParameter reportParamUsername = new ReportParameter("Username", _currentUser1.FullName);

            //ReportViewer1.ServerReport.DisplayName = "What";
            
            ReportViewer1.Reset();

            _reportParameters.Clear();
            _reportParameters.Add(reportParamUsername);

            ReportViewer1.ServerReport.ReportPath = "ReportComprehensiveVhaSummary";

            //var config = RegistriesConfigurations.GetConfig();

            ReportViewer1.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));
            //ReportViewer1.ServerReport.ReportServerUrl = new Uri(config.ReportingServer);
            if (ReportViewer1.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
            //if (ReportViewer1.ServerReport.ReportPath.IndexOf(config.BaseReportPath, 0) == -1)
            {
                ReportViewer1.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewer1.ServerReport.ReportPath;
                //ReportViewer1.ServerReport.ReportPath = config.BaseReportPath + ReportViewer1.ServerReport.ReportPath;
            }
            ReportViewer1.ServerReport.SetParameters(_reportParameters.ToArray());

            ReportViewer1.ProcessingMode = ProcessingMode.Remote;

            ReportViewer1.Visible = true;
            ReportViewer1.ServerReport.Refresh();

        }
        else
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }
    //protected void Button1_Click(object sender, EventArgs e)
    //{
        //ObjectDataSource2.Select();
        //ObjectDataSource2.DataBind();
        //ReportViewer1.DataBind();
        //ReportViewer1.Visible = true;
        //ReportViewer1.LocalReport.Refresh();
    //}

    public bool AccessAllowed()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        return _currentUser.IsInRole(16);
    }
}
