﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="Referrals.aspx.cs" Inherits="TBI_Referrals" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
        <br />
        <br />
        <asp:GridView ID="GridViewTBIReferrals" runat="server" OnRowCommand = "GridViewTBIReferrals_RowCommand"
            AutoGenerateColumns="False" Width="100%"
            DataSourceID="ObjectDataSourceTBIReferrals"
            AllowPaging="True" AllowSorting="True" 
            DataKeyNames="REFERRAL_ID"
            onrowdatabound="GridViewTBIReferrals_RowDataBound">
            <Columns>
                
                <asp:BoundField DataField="REFERRAL_ID" HeaderText="ID" 
                    SortExpression="REFERRAL_ID" AccessibleHeaderText="ID" >

                <ItemStyle HorizontalAlign="Center"/>
                <HeaderStyle HorizontalAlign="Center" />
                </asp:BoundField>

                <asp:TemplateField HeaderText="SSN" SortExpression="PATIENT.SSN" 
                    AccessibleHeaderText="SSN">
                   
                    <ItemTemplate>
                        <asp:Label ID="LabelPatientSSN" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("PATIENT.SSN"))) %>'></asp:Label>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Wrap="false"/>
                <HeaderStyle HorizontalAlign="Center" />
                </asp:TemplateField>
                
                <asp:TemplateField HeaderText="Patient Name" SortExpression="PATIENT.LAST_NAME" 
                    AccessibleHeaderText="Patient Name">
                   <ItemTemplate>
                        <asp:Label ID="LabelPatientLastName" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("PATIENT.LAST_NAME"))) %>'></asp:Label>,&nbsp;
                        <asp:Label ID="LabelPatientFirstName" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("PATIENT.FIRST_NAME"))) %>'></asp:Label>
                        <asp:Label ID="LabelPatientMiddleName" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("PATIENT.MIDDLE_NAME"))) %>'></asp:Label>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Left"/>
                <HeaderStyle HorizontalAlign="Center" />
                </asp:TemplateField>

                <asp:TemplateField HeaderText="Screening Date" SortExpression="REFERRAL_DATE" 
                    AccessibleHeaderText="Referral Date">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelReferralDate" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("REFERRAL_DATE","{0:d}"))) %>'></asp:Label>
                    </ItemTemplate>
                    
                </asp:TemplateField>
 
                <asp:TemplateField HeaderText="VAMC" SortExpression="STD_INSTITUTION.VISN_ID" 
                    AccessibleHeaderText="VAMC">
                    <ItemStyle HorizontalAlign="Left"/>
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        (<asp:Label ID="LabelVamcVisn" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_INSTITUTION.STD_INSTITUTION_PARENT.NAME")))%>'></asp:Label>)
                        (<asp:Label ID="LabelVamcStationNumber" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_INSTITUTION.STATIONNUMBER")))%>'></asp:Label>)
                        <asp:Label ID="LabelVamcVistaName" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_INSTITUTION.VISTANAME")))%>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>

                <asp:TemplateField HeaderText="Status"  
                    AccessibleHeaderText="Status">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelStatusName" runat="server" 
                            Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_REFERRALST.NAME"))) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                
                
                <asp:HyperLinkField DataNavigateUrlFields="REFERRAL_ID" 
                    ItemStyle-HorizontalAlign="Center"  HeaderStyle-HorizontalAlign="Center"
                    DataNavigateUrlFormatString="PatientHealthFactors.aspx?id={0}" 
                    ShowHeader="True" HeaderText="View Patient<br>Health Factors" AccessibleHeaderText="View Patient<br>Health Factors"
                    Text=" View " >  
                    
                    <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
                    <ItemStyle HorizontalAlign="Center"></ItemStyle>

                </asp:HyperLinkField>  
                                                    
                <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details" 
                   ItemStyle-VerticalAlign="Middle" ItemStyle-HorizontalAlign="Center" AccessibleHeaderText = "Select"  />    
                
            </Columns>
        </asp:GridView>
        <asp:ObjectDataSource ID="ObjectDataSourceTBIReferrals" runat="server" 
            SelectMethod="SelectByStatus" 
            SelectCountMethod="SelectByStatusCount" 
            StartRowIndexParameterName="startRow" 
            MaximumRowsParameterName="maxRows" 
            SortParameterName="sort"
            EnablePaging="True"  
            TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIReferralManager"
            >
            <SelectParameters>
                <asp:QueryStringParameter ConvertEmptyStringToNull="true" 
                    DefaultValue="1" Direction="Input" Name="id" QueryStringField="id" Type="Int32" />
                <asp:Parameter Name="sort" Type="String" />
                <asp:Parameter Name="startRow" Type="Int32" />
                <asp:Parameter Name="maxRows" Type="Int32" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <br />
</asp:Content>

