<%@ Page Title="TBI Referral Tracking" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="Referral.aspx.cs" Inherits="TBI_Referrals" MaintainScrollPositionOnPostback="true"%>
<%@ Import Namespace="VeteransAffairs.Registries.Business"%>
<%@ Register src="~/controls/Date.ascx" tagname="Date" tagprefix="UserControlDate" %>
<%@ Register Assembly="System.Web.DynamicData, Version=3.5.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35"
    Namespace="System.Web.DynamicData" TagPrefix="cc2" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>
<%@ Register src="controls/ErrorList.ascx" tagname="ErrorList" tagprefix="uc1" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">

    <script src="scripts/date.js" type="text/javascript"></script>
    
    <script type = "text/javascript">
        $(window).load(function() {
        });
        $(document).ready(function() {
            if ($('#<%=CheckBoxNotApplicable.ClientID %>').is(":checked")) {

                //CheckBoxNotApplicable was checked
                //////////////////////////////////////////////////////////////////

                if ($('#<%=FormIsReadOnly.ClientID %>').val() == '0') {

                    //enable DropDownListOtherConsultStatus
                    $('#<%=DropDownListOtherConsultStatus.ClientID %>').removeAttr('disabled');

                    //clear TextBoxDateConsultReferral
                    $('#<%=TextBoxDateConsultReferral.ClientID %>').val('');
                    //disable TextBoxDateConsultReferral
                    $('#<%=TextBoxDateConsultReferral.ClientID %>').attr('disabled', 'disabled');
                }

                if ($('#<%=DropDownListOtherConsultStatus.ClientID %>').val() == '1') {
                    //DropDownListOtherConsultStatus has Consult not submitted selected
                    //////////////////////////////////////////////////////////////////

                    //show ConsultNotSubmittedNotice
                    $('#<%=LiteralConsultNotSubmittedNotice.ClientID %>').show();
                }
                else {
                    //DropDownListOtherConsultStatus does not have Consult not submitted selected
                    //////////////////////////////////////////////////////////////////

                    //hide ConsultNotSubmittedNotice 
                    $('#<%=LiteralConsultNotSubmittedNotice.ClientID %>').hide();
                }
            }
            else {
                //CheckBoxNotApplicable was unchecked
                //////////////////////////////////////////////////////////////////

                //disable DropDownListOtherConsultStatus
                $('#<%=DropDownListOtherConsultStatus.ClientID %>').attr('disabled', 'disabled');

                //reset DropDownListOtherConsultStatus to no selection
                $('#<%=DropDownListOtherConsultStatus.ClientID %>').val('');

                if ($('#<%=FormIsReadOnly.ClientID %>').val() == '0') {

                    if ($('#<%=CheckBoxNotApplicable.ClientID %>').val() == '0') {
                        //enable TextBoxDateConsultReferral
                        $('#<%=TextBoxDateConsultReferral.ClientID %>').removeAttr('disabled');
                    }
                }

                //hide ConsultNotSubmittedNotice
                $('#<%=LiteralConsultNotSubmittedNotice.ClientID %>').hide();

            }

            //DropDownListResponsibleTeam client side change event
            if ($('#<%=DropDownListResponsibleTeam.ClientID %>').val() == '5') {
                //DropDownListResponsibleTeam has Other selected
                //////////////////////////////////////////////////////////////////

                //show ResponsibleTeamOtherRow
                $('#<%=ResponsibleTeamOtherRow.ClientID %>').show();
            }
            else {
                //DropDownListResponsibleTeam does not have Other selected
                //////////////////////////////////////////////////////////////////

                //hide ResponsibleTeamOtherRow
                $('#<%=ResponsibleTeamOtherRow.ClientID %>').hide();

                //set TextBoxResponsibleTeamOther to empty string
                $('#<%=TextBoxResponsibleTeamOther.ClientID %>').val('');
            }


            //CheckBoxNotApplicablehand client side click event 
            $('#<%=CheckBoxNotApplicable.ClientID %>').click(function() {
                if ($(this).is(":checked")) {

                    //CheckBoxNotApplicable was checked
                    //////////////////////////////////////////////////////////////////

                    //enable DropDownListOtherConsultStatus
                    $('#<%=DropDownListOtherConsultStatus.ClientID %>').removeAttr('disabled');

                    //clear TextBoxDateConsultReferral
                    $('#<%=TextBoxDateConsultReferral.ClientID %>').val('');

                    //disable TextBoxDateConsultReferral
                    $('#<%=TextBoxDateConsultReferral.ClientID %>').attr('disabled', 'disabled');

                    //disable consult date validator
                    ValidatorEnable($('[id*=RequiredFieldValidatorForTextBoxDateConsultReferral]')[0], false);
                }
                else {
                    //CheckBoxNotApplicable was unchecked
                    //////////////////////////////////////////////////////////////////

                    //disable DropDownListOtherConsultStatus
                    $('#<%=DropDownListOtherConsultStatus.ClientID %>').attr('disabled', 'disabled');

                    //reset DropDownListOtherConsultStatus to no selection
                    $('#<%=DropDownListOtherConsultStatus.ClientID %>').val('');

                    //enable TextBoxDateConsultReferral
                    $('#<%=TextBoxDateConsultReferral.ClientID %>').removeAttr('disabled');

                    //hide ConsultNotSubmittedNotice
                    $('#<%=LiteralConsultNotSubmittedNotice.ClientID %>').hide();

                    //enable consult date validator
                    ValidatorEnable($('[id*=RequiredFieldValidatorForTextBoxDateConsultReferral]')[0], true);
                    var validator = $('[id*=RequiredFieldValidatorForTextBoxDateConsultReferral]')[0];
                    validator.isvalid = true;
                    ValidatorUpdateDisplay(validator);
                    
                }

            });

            //DropDownListOtherConsultStatus client side change event
            $('#<%=DropDownListOtherConsultStatus.ClientID %>').change(function() {

                if ($(this).val() == '1') {
                    //DropDownListOtherConsultStatus has Consult not submitted selected
                    //////////////////////////////////////////////////////////////////

                    //show ConsultNotSubmittedNotice
                    $('#<%=LiteralConsultNotSubmittedNotice.ClientID %>').show();
                }
                else {
                    //DropDownListOtherConsultStatus does not have Consult not submitted selected
                    //////////////////////////////////////////////////////////////////

                    //hide ConsultNotSubmittedNotice 
                    $('#<%=LiteralConsultNotSubmittedNotice.ClientID %>').hide();
                }

            });


//            function parseDate(str) {
//                var mdy = str.split('/');            
//                return new Date(mdy[2], mdy[0] - 1, mdy[1]);
//            }

            function daydiff(first, second) {
                return Math.round((second - first) / (1000 * 60 * 60 * 24))
            }

            //TextBoxDateScheduledWithTBIEvaluationTeam client side blud event
            $('#<%=TextBoxDateScheduledWithTBIEvaluationTeam.ClientID %>').blur(function() {

                //compute days to schedule appointment if TextBoxDateScheduledWithTBIEvaluationTeam is not empty
                //if ($(this).val() != '') {

                var dateDiff = daydiff(
                            Date.parse($('#<%=LabelReferralDate.ClientID %>').text(), "mm/dd/yyyy")
                          , Date.parse($('#<%=TextBoxDateScheduledWithTBIEvaluationTeam.ClientID %>').val(), "mm/dd/yyyy")
                        )

                //set days to schedule appointment
                if (isNaN(dateDiff) || dateDiff < 0) {
                    $('#<%=LabelTimeToScheduledAppointmentWithTBITeam.ClientID %>').text('');
                }
                else {
                    $('#<%=LabelTimeToScheduledAppointmentWithTBITeam.ClientID %>').text(dateDiff);
                }
            });


            //TextBoxDateScheduledTBI1 client side blud event
            $('#<%=TextBoxDateScheduledTBI1.ClientID %>').blur(function() {

                //compute days to schedule appointment if TextBoxDateScheduledWithTBIEvaluationTeam is not empty
                //if ($(this).val() != '') {

                var dateDiff = daydiff(
                            Date.parse($('#<%=LabelReferralDate.ClientID %>').text(), "mm/dd/yyyy")
                          , Date.parse($('#<%=TextBoxDateScheduledTBI1.ClientID %>').val(), "mm/dd/yyyy")
                        )

                //set days to schedule appointment
                if (isNaN(dateDiff) || dateDiff < 0) {
                    $('#<%=LabelTimeScheduledTBI1.ClientID %>').text('');
                }
                else {
                    $('#<%=LabelTimeScheduledTBI1.ClientID %>').text(dateDiff);
                }
            });

            //TextBoxDateScheduledTBI2 client side blud event
            $('#<%=TextBoxDateScheduledTBI2.ClientID %>').blur(function() {

                //compute days to schedule appointment if TextBoxDateScheduledWithTBIEvaluationTeam is not empty
                //if ($(this).val() != '') {

                var dateDiff = daydiff(
                            Date.parse($('#<%=LabelReferralDate.ClientID %>').text(), "mm/dd/yyyy")
                          , Date.parse($('#<%=TextBoxDateScheduledTBI2.ClientID %>').val(), "mm/dd/yyyy")
                        )

                //set days to schedule appointment
                if (isNaN(dateDiff) || dateDiff < 0) {
                    $('#<%=LabelTimeScheduledTBI2.ClientID %>').text('');
                }
                else {
                    $('#<%=LabelTimeScheduledTBI2.ClientID %>').text(dateDiff);
                }


                //}

            });


            //TextBoxDateEvaluationCompleted client side blur event
            $('#<%=TextBoxDateEvaluationCompleted.ClientID %>').blur(function() {


                //compute days to evaluation completed if TextBoxDateEvaluationCompleted is not empty
                //if ($(this).val() != '') {

                var dateDiff = daydiff(
                            Date.parse($('#<%=LabelReferralDate.ClientID %>').text(), "mm/dd/yyyy")
                          , Date.parse($('#<%=TextBoxDateEvaluationCompleted.ClientID %>').val(), "mm/dd/yyyy")
                        )

                //set days to schedule appointment
                if (isNaN(dateDiff) || dateDiff < 0) {
                    $('#<%=LabelTimeToCompleteEvaluation.ClientID %>').text('');
                }
                else {
                    $('#<%=LabelTimeToCompleteEvaluation.ClientID %>').text(dateDiff);
                }
            });

            $('#<%=TextBoxDateEvaluationCompleted.ClientID %>').change(function() {
                if ($(this).val().length == 0) {

                    $('td.controls select').val('');
                    $('td.controls select').attr('disabled', 'disabled');


                }
                else {
                    $('td.controls select').removeAttr('disabled');

                }

            });
            //DropDownListResponsibleTeam client side change event
            $('#<%=DropDownListResponsibleTeam.ClientID %>').change(function() {

                if ($(this).val() == '5') {
                    //DropDownListResponsibleTeam has Other selected
                    //////////////////////////////////////////////////////////////////

                    //show ResponsibleTeamOtherRow
                    $('#<%=ResponsibleTeamOtherRow.ClientID %>').show();
                }
                else {
                    //DropDownListResponsibleTeam does not have Other selected
                    //////////////////////////////////////////////////////////////////

                    //hide ResponsibleTeamOtherRow
                    $('#<%=ResponsibleTeamOtherRow.ClientID %>').hide();

                    //set TextBoxResponsibleTeamOther to empty string
                    $('#<%=TextBoxResponsibleTeamOther.ClientID %>').val('')
                }

            });



        });
    </script>
    <asp:ValidationSummary ID="TBIValidationSummaryOnSave" runat="server" 
        TabIndex="1" 
        HeaderText="The page has the following data errors:" 
        DisplayMode="BulletList" 
        ShowSummary="false" 
        ShowMessageBox="true" 
        ValidationGroup="OnSave" />
    <asp:ValidationSummary ID="TBIValidationSummaryOnComplete" runat="server" 
        TabIndex="2" 
        HeaderText="The page has the following data errors:" 
        DisplayMode="BulletList" 
        ShowSummary="false" 
        ShowMessageBox="true" 
        ValidationGroup="OnComplete" />
    <br />
    <br />
    <asp:Panel ID="PanelObjectContent" runat="server">
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <asp:HyperLink 
                TabIndex="3" ID="HyperLinkDefinitions" runat="server" Target="_blank" NavigateUrl="~/documents/TBIAPPLICATIONFIELDDEFINITIONS.doc">Click here to view Data Definitions for each of the fields</asp:HyperLink>
            <asp:HiddenField ID="HiddenFieldReferralID" Value="0" runat="server" />
            <uc1:ErrorList TabIndex="4" ID="ErrorList1" runat="server" />
            <table  cellpadding="3" cellspacing="3" border="0" width="100%">
                <tr>
                    <td>
                        <asp:Label ID="LabelforLabelFacility" runat="server" 
                            AssociatedControlID="LabelFacility" SkinID="DataLabel">Facility:</asp:Label>
                    </td>
                    <td>
                        <asp:Label ID="LabelFacility" TabIndex="5" runat="server" SkinID="DataLabel"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="LabelforLabelPatientNameSnum" runat="server" 
                            AssociatedControlID="LabelPatientNameSnum" SkinID="DataLabel">Name/SS# of Patient with Positive Screen and Desiring Eval:</asp:Label>
                    </td>
                    <td>
                        <asp:Label ID="LabelPatientNameSnum" TabIndex="6" runat="server" 
                            SkinID="DataLabel"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="LabelForLabelReferralDate" runat="server" 
                            AssociatedControlID="LabelReferralDate" SkinID="DataLabel">
                             Date of Screening (mm/dd/yyyy):
                        </asp:Label>
                    </td>
                    <td>                            
                        <asp:Label ID="LabelReferralDate" runat="server" SkinID="DataLabel" ></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="LabelDateConsultReferral" runat="server" 
                            AssociatedControlID="TextBoxDateConsultReferral">
                            Date of Consult/Referral (mm/dd/yyyy):
                        </asp:Label>
                    </td>
                    <td>
                        <asp:TextBox ID="TextBoxDateConsultReferral" runat="server"
                            TabIndex="7" />                    
                        <asp:RangeValidator ID="RangeValidatorTextBoxDateConsultReferral" runat="server" 
                            ValidationGroup="OnSave" 
                            TabIndex="8"  
                            EnableClientScript="true" 
                            SetFocusOnError="true" 
                            ErrorMessage="Date of Consult/Referral needs to be in format mm/dd/yyyy; equal/later than Date of Screening; and today or earlier." 
                            Type="Date" 
                            Display = "Dynamic" 
                            ControlToValidate="TextBoxDateConsultReferral" >
                        </asp:RangeValidator>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorForTextBoxDateConsultReferral" runat="server" 
                            TabIndex="9"
                            ValidationGroup="OnComplete" 
                            EnableClientScript="true" 
                            SetFocusOnError="true" 
                            ErrorMessage="Date of Consult/Referral is required to move to completed status" 
                            Display = "Dynamic" 
                            ControlToValidate="TextBoxDateConsultReferral" >
                        </asp:RequiredFieldValidator>                       
                     </td>
                </tr>
                <tr>
                    <td>
                    </td>
                    <td>
                       <asp:CheckBox ID="CheckBoxNotApplicable" runat="server"
                            TabIndex="10"  
                            Text="Not Applicable" 
                            TextAlign="Right"/> 
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="LabelforDropDownListOtherConsultStatus" runat="server" 
                            AssociatedControlID="DropDownListOtherConsultStatus">
                            Other Consult Referral Status:
                        </asp:Label>
                    </td>
                    <td>
                        <asp:DropDownList ID="DropDownListOtherConsultStatus" 
                            CssClass="tbiReferralDropDownListWidth"
                            TabIndex="11" 
                            runat="server" 
                            AutoPostBack="false" 
                            DataSourceID="ObjectDataSourceOtherConsultStatus" DataTextField="NAME" 
                            DataValueField="ID"
                            AppendDataBoundItems="true">
                            <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                        </asp:DropDownList>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorDropDownListOtherConsultStatus" runat="server" 
                            TabIndex="12" 
                            ControlToValidate="DropDownListOtherConsultStatus"
                            SetFocusOnError="true"
                            EnableClientScript="false"
                            ValidationGroup="OnComplete"
                            ErrorMessage="Other Consult Referral Status is required when Not Applicable is checked."></asp:RequiredFieldValidator>
                        <asp:CompareValidator ID="CompareValidatorConsultStatusConsultNotSubmittedOnSave" runat="server" 
                            TabIndex="13" 
                            Enabled="false" 
                            ControlToValidate="DropDownListOtherConsultStatus"
                            SetFocusOnError="true"
                            EnableClientScript="false"
                            ValidationGroup="OnComplete"
                            ValueToCompare="Consult Not Submitted"
                            ErrorMessage="
                             - Further evaluation is required for this patient.  Please arrange for comprehensive TBI evaluation for this patient and update this patient entry in the TBI Screening and Evaluation Tracking Application once those arrangements have been made.  The status of this case cannot move to 'completed' until this field has been changed to reflect the follow up status for this patient.">
                        </asp:CompareValidator>
                        <asp:ObjectDataSource ID="ObjectDataSourceOtherConsultStatus" runat="server" 
                            SelectMethod="GetTBIOtherConsultStatusList" 
                            TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists" 
                            OldValuesParameterFormatString="original_{0}">
                        </asp:ObjectDataSource>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <asp:Label ID="LiteralConsultNotSubmittedNotice" 
                            TabIndex="14" 
                            runat="server"
                            Text="Consult not submitted - Further evaluation is required for this patient.  Please arrange for comprehensive TBI evaluation for this patient and update this patient entry in the TBI Screening and Evaluation Tracking Application once those arrangements have been made.  The status of this case cannot move to 'completed' until this field has been changed to reflect the follow up status for this patient."
                            BorderStyle="Solid"
                            BorderWidth="1px"
                            ForeColor="Black" SkinID="DataLabel"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="LabelforDropDownListAttempts" runat="server" 
                            AssociatedControlID="DropDownListAttempts">
                            Attempts to Contact Patient for Scheduling Purposes:
                        </asp:Label>
                    </td>
                    <td>
                        <asp:DropDownList ID="DropDownListAttempts" 
                            CssClass="tbiReferralDropDownListWidth"
                            TabIndex="15" 
                            runat="server" 
                            AutoPostBack="False" 
                            DataSourceID="ObjectDataSourceAttemptsStatus" DataTextField="NAME"
                            DataValueField="ID"
                            AppendDataBoundItems="true">
                            <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                        </asp:DropDownList>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorDropDownListAttempts" runat="server" 
                            TabIndex="16" 
                            ControlToValidate="DropDownListAttempts"
                            SetFocusOnError="true"
                            EnableClientScript="false"
                            ValidationGroup="OnComplete" 
                            ErrorMessage="Attempts to Contact Patient for Scheduling Purposes is required to move to completed status.">
                        </asp:RequiredFieldValidator>
                        <asp:ObjectDataSource ID="ObjectDataSourceAttemptsStatus" runat="server" 
                            SelectMethod="GetTBISheduleStatusList" 
                            TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
                        </asp:ObjectDataSource>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="LabelforTextBoxDateScheduledWithTBIEvaluationTeam" runat="server" 
                            AssociatedControlID="TextBoxDateScheduledWithTBIEvaluationTeam">
                            Date Scheduled with TBI Evaluation Team (mm/dd/yyyy):
                        </asp:Label>
                    </td>
                    <td>
                        <asp:TextBox ID="TextBoxDateScheduledWithTBIEvaluationTeam" runat="server" 
                            TabIndex="17" 
                            Text="" 
                            ToolTip="(mm/dd/yyyy)" />
                        <asp:CompareValidator ID = "CompareValidatorTextBoxDateScheduledWithTBIEvaluationTeamMin" runat = "server" 
                            ControlToValidate = "TextBoxDateScheduledWithTBIEvaluationTeam"  
                            ValueToCompare = '#<%=LabelReferralDate.Text %>'
                            SetFocusOnError = "true" 
                            ValidationGroup = "OnSave" 
                            EnableClientScript = "true" 
                            Operator = "GreaterThanEqual"  
                            ErrorMessage = "Date Scheduled with TBI Evaluation Team needs to be in format (mm/dd/yyyy) and equal/later than Date of Screening." 
                            Display = "Dynamic" 
                            Type= "Date"/>   
                        <asp:CompareValidator ID = "CompareValidatorTextBoxDateScheduledWithTBIEvaluationTeamMax" runat = "server" 
                            ControlToValidate = "TextBoxDateScheduledWithTBIEvaluationTeam" 
                            ControlToCompare = "TextBoxDateEvaluationCompleted" 
                            SetFocusOnError = "true" 
                            ValidationGroup = "OnSave" 
                            EnableClientScript = "true" 
                            Operator = "LessThanEqual" 
                            ErrorMessage = "Date Scheduled with TBI Evaluation Team needs to be earlier than Date Evaluation Completed." 
                            Display = "Dynamic" 
                            Type= "Date"/>   
                         <asp:RequiredFieldValidator ID="RequiredFieldValidatorForTextBoxDateScheduledWithTBIEvaluationTeam" 
                            runat="server" 
                            TabIndex="19" 
                            SetFocusOnError="true"
                            ValidationGroup="OnComplete"
                            ControlToValidate="TextBoxDateScheduledWithTBIEvaluationTeam"
                            EnableClientScript="false"
                            ErrorMessage="Date Scheduled with TBI Evaluation Team is required to move to completed status.">
                        </asp:RequiredFieldValidator>
                       <br />  
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="LabelforLabelTimeToScheduledAppointmentWithTBITeam" runat="server" 
                            AssociatedControlID="LabelTimeToScheduledAppointmentWithTBITeam" 
                            SkinID="DataLabel">
                             Time to Scheduled Appointment with TBI Evaluation Team:
                        </asp:Label>
                    </td>
                    <td>
                        <asp:Label ID="LabelTimeToScheduledAppointmentWithTBITeam" runat="server" 
                            TabIndex="20" SkinID="DataLabel" ></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="LabelforDropDownListDelayCompletingEvaluation" runat="server" 
                            AssociatedControlID="DropDownListDelayCompletingEvaluation">
                            Delay in Completing Evaluation:
                        </asp:Label>
                    </td>
                    <td>
                        <asp:DropDownList ID="DropDownListDelayCompletingEvaluation" 
                            CssClass="tbiReferralDropDownListWidth"
                            TabIndex="21" 
                            runat="server" 
                            AutoPostBack="true" 
                            DataSourceID="ObjectDataSourceDelayType"
                            DataTextField="NAME" 
                            DataValueField="ID"
                            AppendDataBoundItems="true">
                            <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                        </asp:DropDownList>
                        <asp:RequiredFieldValidator 
                            ID="RequiredFieldValidatorDropDownListDelayCompletingEvaluation" 
                            TabIndex="22" 
                            runat="server" 
                            SetFocusOnError="true"
                            ValidationGroup="OnComplete"
                            EnableClientScript="false"
                            ControlToValidate="DropDownListDelayCompletingEvaluation" 
                            ErrorMessage="Delay in Completing Evaluation is required to move to completed status">
                        </asp:RequiredFieldValidator>
                        <asp:ObjectDataSource ID="ObjectDataSourceDelayType" runat="server" 
                            SelectMethod="GetTBIDelayTypeList" 
                            TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
                        </asp:ObjectDataSource>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <asp:Label runat="server" ID="LabelDisplayNoticeForMultipleAttempts" 
                            TabIndex="23" 
                            Text="Cases for which an entry of 'Cancelled by Patient' or 'No Show' require further attempts at scheduling an appointment by the clinic, which should be indicated on this form beginning with the 'Attempts to Contact Patient for Scheduling Purposes' field.  This application will capture up to 3 attempts to schedule and complete the TBI evaluation.  Cases where a total of 3 cancellations by the patient and/or no shows will satisfy the requirements of this tracking application."
                            Visible="False"  
                            BorderStyle="Solid"
                            BorderWidth="1px"
                            ForeColor="Black" SkinID="DataLabel"></asp:Label>
                    </td>
                </tr>
                <tr runat="server" id="att1" visible="false">
                    <td>
                        <asp:Label ID="LabelforDropDownListSecondContactAttempt" runat="server" 
                            AssociatedControlID="DropDownListSecondContactAttempt">
                            Second Attempt to Contact Patient for Scheduling Purposes:
                        </asp:Label>
                    </td>
                    <td>
                        <asp:DropDownList ID="DropDownListSecondContactAttempt" 
                            CssClass="tbiReferralDropDownListWidth"
                            TabIndex="24" 
                            runat="server" 
                            AppendDataBoundItems="true" 
                            AutoPostBack="false" 
                            DataSourceID="ObjectDataSourceAttemptsStatus" 
                            DataTextField="NAME" 
                            DataValueField="ID">
                            <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                        </asp:DropDownList>
                        <asp:RequiredFieldValidator 
                            ID="RequiredFieldValidatorForDropDownListSecondContactAttempt" 
                            TabIndex="25" 
                            runat="server" 
                            SetFocusOnError="true"
                            ValidationGroup="OnComplete"
                            EnableClientScript="false"
                            ControlToValidate="DropDownListSecondContactAttempt" 
                            ErrorMessage="Second Attempt to Contact Patient for Scheduling Purposes is required to move to completed status">
                        </asp:RequiredFieldValidator>
                    </td>
                </tr>
                <tr runat="server" id="att3" visible="false">
                    <td>
                        <asp:Label ID="LabelforTextBoxDateScheduledTBI1" runat="server" 
                            AssociatedControlID="TextBoxDateScheduledTBI1">
                            Second Date Scheduled with TBI Evaluation Team (mm/dd/yyyy):
                        </asp:Label>
                    </td>
                    <td>
                        <asp:TextBox runat="server" ID="TextBoxDateScheduledTBI1" 
                            TabIndex="26">
                        </asp:TextBox>
                        <asp:CompareValidator ID = "CompareValidatorTextBoxDateScheduledTBI1Min" runat = "server" 
                            ControlToValidate = "TextBoxDateScheduledTBI1" 
                            ControlToCompare = "TextBoxDateScheduledWithTBIEvaluationTeam" 
                            SetFocusOnError = "true" 
                            ValidationGroup = "OnSave" 
                            EnableClientScript = "true" 
                            Operator = "GreaterThanEqual"
                            ErrorMessage = "Second Date Scheduled with TBI Evaluation Team needs to be in format (mm/dd/yyyy) and equal/later than First Date Scheduled." 
                            Display = "Dynamic" 
                            Type= "Date"/>   
                        <asp:CompareValidator ID = "CompareValidatorTextBoxDateScheduledTBI1Max" runat = "server" 
                            ControlToValidate = "TextBoxDateScheduledTBI1" 
                            ControlToCompare = "TextBoxDateEvaluationCompleted" 
                            SetFocusOnError = "true" 
                            ValidationGroup = "OnSave" 
                            EnableClientScript = "true" 
                            Operator = "LessThanEqual" 
                            ErrorMessage = "Second Date Scheduled with TBI Evaluation Team needs to be earlier than Date Evaluation Completed." 
                            Display = "Dynamic" 
                            Type= "Date"/>   
                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorForTextBoxDateScheduledTBI1" 
                            runat="server" 
                            TabIndex="28"
                            SetFocusOnError="true"
                            ValidationGroup="OnComplete"
                            EnableClientScript="false"
                            ControlToValidate="TextBoxDateScheduledTBI1"
                            ErrorMessage="Second Date Scheduled with TBI Evaluation Team is required to move to completed status">
                       </asp:RequiredFieldValidator>
                    </td>
                </tr>
                <tr runat="server" id="att5" visible="false">
                    <td>
                        <asp:Label ID="LabelforLabelTimeScheduledTBI1" runat="server" 
                            AssociatedControlID="LabelTimeScheduledTBI1" SkinID="DataLabel">
                             Second Time to Scheduled Appointment with TBI Evaluation Team:
                        </asp:Label>
                    </td>
                    <td>
                        &nbsp;<asp:Label runat="server" ID="LabelTimeScheduledTBI1" TabIndex="29" 
                            Font-Bold="True" SkinID="DataLabel"></asp:Label>
                    </td>
                </tr>
                <tr runat="server" id="att7" visible="false">
                    <td>
                        <asp:Label ID="LabelforDropDownListDelay1" runat="server" 
                            AssociatedControlID="DropDownListDelay1">
                            Second Delay in Completing Evaluation:
                        </asp:Label>
                    </td>
                    <td>
                        <asp:DropDownList ID="DropDownListDelay1" runat="server" 
                            TabIndex="30"  
                            CssClass="tbiReferralDropDownListWidth"
                            AutoPostBack="true" 
                            DataSourceID="ObjectDataSourceDelayType"
                            DataTextField="NAME" 
                            DataValueField="ID"
                            AppendDataBoundItems="true">
                            <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                        </asp:DropDownList>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorForDropDownListDelay1" 
                            runat="server" 
                            TabIndex="31"
                            SetFocusOnError="true"
                            ValidationGroup="OnComplete"
                            ControlToValidate="DropDownListDelay1"
                            EnableClientScript="false"
                            ErrorMessage="Second Delay in Completing Evaluation is required to move to completed status">
                        </asp:RequiredFieldValidator>
                    </td>
                </tr>
                <tr runat="server" id="att9" visible="false">
                    <td>
                        <asp:Label ID="LabelforDropDownListAttempts2" runat="server" 
                            AssociatedControlID="DropDownListAttempts2">
                            Third Attempt to Contact Patient for Scheduling Purposes:
                        </asp:Label>
                    </td>
                    <td>
                        <asp:DropDownList ID="DropDownListAttempts2" 
                            CssClass="tbiReferralDropDownListWidth"
                            TabIndex="32" 
                            runat="server" 
                            AutoPostBack="false" 
                            DataSourceID="ObjectDataSourceAttemptsStatus" 
                            DataTextField="NAME"
                            DataValueField="ID"
                            AppendDataBoundItems="true">
                            <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                        </asp:DropDownList>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorForDropDownListAttempts2" 
                            runat="server" 
                            TabIndex="33"
                            SetFocusOnError="true"
                            ValidationGroup="OnComplete"
                            ControlToValidate="DropDownListAttempts2"
                            EnableClientScript="false"
                            ErrorMessage="Third Attempt to Contact Patient for Scheduling Purposes is required to move to completed status">
                        </asp:RequiredFieldValidator>
                    </td>
                </tr>
                <tr runat="server" id="att11" visible="false">
                    <td>
                        <asp:Label ID="LabelforTextBoxDateScheduledTBI2" runat="server" 
                                AssociatedControlID="TextBoxDateScheduledTBI2">
                                Third Date Scheduled with TBI Evaluation Team (mm/dd/yyyy):
                            </asp:Label>
                    </td>
                    <td>
                        <asp:TextBox runat="server" ID="TextBoxDateScheduledTBI2" 
                            TabIndex="34">
                        </asp:TextBox>
                        <asp:CompareValidator ID = "CompareValidatorTextBoxDateScheduledTBI2Min" runat = "server" 
                            ControlToValidate = "TextBoxDateScheduledTBI2" 
                            ControlToCompare = "TextBoxDateScheduledTBI1" 
                            SetFocusOnError = "true" 
                            ValidationGroup = "OnSave" 
                            EnableClientScript = "true" 
                            Operator = "GreaterThanEqual"
                            ErrorMessage = "Third Date Scheduled with TBI Evaluation Team needs to be in format (mm/dd/yyyy) and equal/later than Second Date Scheduled." 
                            Display = "Dynamic" 
                            Type= "Date"/>   
                        <asp:CompareValidator ID = "CompareValidatorTextBoxDateScheduledTBI2Max" runat = "server" 
                            ControlToValidate = "TextBoxDateScheduledTBI2" 
                            ControlToCompare = "TextBoxDateEvaluationCompleted" 
                            SetFocusOnError = "true" 
                            ValidationGroup = "OnSave" 
                            EnableClientScript = "true" 
                            Operator = "LessThanEqual" 
                            ErrorMessage = "Third Date Scheduled with TBI Evaluation Team needs to be earlier than Date Evaluation Completed." 
                            Display = "Dynamic" 
                            Type= "Date"/>   
                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorForTextBoxDateScheduledTBI2" 
                            runat="server" 
                            TabIndex="36"
                            SetFocusOnError="true"
                            ValidationGroup="OnComplete"
                            ControlToValidate="TextBoxDateScheduledTBI2"
                            EnableClientScript="false"
                            ErrorMessage="Third Date Scheduled with TBI Evaluation Team is required to move to completed status.">
                        </asp:RequiredFieldValidator>
                    </td>
                </tr>
                <tr runat="server" id="att13" visible="false">
                    <td>
                        <asp:Label ID="LabelforLabelTimeScheduledTBI2" runat="server" 
                            AssociatedControlID="LabelTimeScheduledTBI2" SkinID="DataLabel">Third Time to Scheduled Appointment with TBI Evaluation Team:</asp:Label>
                    </td>
                    <td>
                        &nbsp;<asp:Label runat="server" ID="LabelTimeScheduledTBI2" TabIndex="37" 
                            Font-Bold="True" SkinID="DataLabel"></asp:Label>
                    </td>
                </tr>
                <tr runat="server" id="att15" visible="false">
                    <td>
                        <asp:Label ID="LabelforDropDownListDelay2" runat="server" 
                            AssociatedControlID="DropDownListDelay2">
                            Third Delay in Completing Evaluation:
                        </asp:Label>
                    </td>
                    <td>
                        <asp:DropDownList ID="DropDownListDelay2" runat="server" 
                            TabIndex="38" 
                            CssClass="tbiReferralDropDownListWidth"
                            AutoPostBack="true" 
                            DataSourceID="ObjectDataSourceDelayType"
                            DataTextField="NAME" 
                            DataValueField="ID"
                            AppendDataBoundItems="true">
                            <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                        </asp:DropDownList>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorForDropDownListDelay2" 
                            runat="server" 
                            TabIndex="39"
                            SetFocusOnError="true"
                            ValidationGroup="OnComplete"
                            ControlToValidate="DropDownListDelay2"
                            EnableClientScript="false"
                            ErrorMessage="Third Delay in Completing Evaluation is required to move to completed status.">
                        </asp:RequiredFieldValidator>
                    </td>
                </tr>
                <tr runat="server" id="att16" visible="false">
                    <td>
                        <asp:Label ID="LabelforLabelNumberOfNoShows" runat="server" SkinID="DataLabel" AssociatedControlID="LabelNumberOfNoShows">Multiple Patient No Show/Cancellation:</asp:Label>
                    </td>
                    <td>
                        <asp:Label ID="LabelNumberOfNoShows" TabIndex="40" runat="server" 
                            Font-Bold="True" SkinID="DataLabel" ></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="LabelforTextBoxDateEvaluationCompleted" runat="server" 
                            AssociatedControlID="TextBoxDateEvaluationCompleted">
                            Date Evaluation Completed (mm/dd/yyyy):
                        </asp:Label>
                    </td>
                    <td>
                        <asp:TextBox ID="TextBoxDateEvaluationCompleted" runat="server" 
                            TabIndex="41" 
                            Text="" />                    
                        <asp:RangeValidator ID="RangeValidatorTextBoxDateEvaluationCompleted" runat="server" 
                            TabIndex="42"   
                            MaximumValue="01/01/3000"
                            MinimumValue="01/01/1900" 
                            EnableClientScript="true" 
                            ValidationGroup="OnSave"
                            SetFocusOnError="true" 
                            ErrorMessage="Date Evaluation Completed needs to be in format mm/dd/yyyy; equal/later than Date of Screening; and today or earlier." 
                            Type="Date" 
                            Display = "Dynamic" 
                            ControlToValidate="TextBoxDateEvaluationCompleted" >
                        </asp:RangeValidator>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorForTextBoxDateEvaluationCompleted" 
                            runat="server" 
                            TabIndex="43"
                            SetFocusOnError="true"
                            ValidationGroup="OnComplete"
                            EnableClientScript="false"
                            ControlToValidate="TextBoxDateEvaluationCompleted"
                            ErrorMessage="Date Evaluation Completed is required to move to completed status.">
                        </asp:RequiredFieldValidator>
                        <br />
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="LabelforLabelTimeToCompleteEvaluation" runat="server" 
                            AssociatedControlID="LabelTimeToCompleteEvaluation" SkinID="DataLabel">Time to Complete Evaluation:
                        </asp:Label>
                    </td>
                    <td>
                        <asp:Label ID="LabelTimeToCompleteEvaluation" runat="server"
                            TabIndex="44" SkinID="DataLabel" ></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="LabelforDropDownListDefinitiveTBIDiagnosis" runat="server" 
                            AssociatedControlID="DropDownListDefinitiveTBIDiagnosis">
                            Definitive TBI Diagnosis:
                        </asp:Label>
                    </td>
                    <td class = "controls">
                        <asp:DropDownList ID="DropDownListDefinitiveTBIDiagnosis"
                            CssClass="tbiReferralDropDownListWidth"
                            TabIndex="45" 
                            runat="server">
                            <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                        </asp:DropDownList>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorListDefinitiveTBIDiagnosis" 
                            runat="server" 
                            TabIndex="46"
                            SetFocusOnError="true"
                            ValidationGroup="OnComplete"
                            ControlToValidate="DropDownListDefinitiveTBIDiagnosis"
                            EnableClientScript="false"
                            ErrorMessage="Definitive TBI Diagnosis is required to move to completed status">
                        </asp:RequiredFieldValidator>
                        
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="LabelforDropDownListResponsibleTeam" runat="server" 
                            AssociatedControlID="DropDownListResponsibleTeam">
                            Responsible TBI Evaluation Team (Service/Clinic):
                        </asp:Label>
                    </td>
                    <td class = "controls">
                        <asp:DropDownList ID="DropDownListResponsibleTeam" runat="server" 
                            TabIndex="47" 
                            CssClass="tbiReferralDropDownListWidth"
                            AutoPostBack="false" 
                            DataSourceID="ObjectDataSourceResponsibleTeam"
                            DataTextField="NAME" 
                            DataValueField="ID"
                            AppendDataBoundItems="true" 
                            onselectedindexchanged="DropDownListResponsibleTeam_SelectedIndexChanged">
                            <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                        </asp:DropDownList>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorResponsibleTeam" 
                            runat="server" 
                            TabIndex="48"
                            SetFocusOnError="true"
                            ValidationGroup="OnComplete"
                            ControlToValidate="DropDownListResponsibleTeam"
                            EnableClientScript="false"
                            ErrorMessage="Responsible TBI Evaluation Team (Service/Clinic) is required to move to completed status">
                        </asp:RequiredFieldValidator>

                        <asp:ObjectDataSource ID="ObjectDataSourceResponsibleTeam" runat="server" 
                            SelectMethod="GetTBIResponsibleTeam" 
                            TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
                        </asp:ObjectDataSource>
                    </td>
                </tr>
                <asp:TableRow runat="server" ID="ResponsibleTeamOtherRow" Visible="true"> 
                    <asp:TableCell>
                        <asp:Label ID="LabelforTextBoxResponsibleTeamOther" runat="server" 
                                AssociatedControlID="TextBoxResponsibleTeamOther" 
                                Visible="true">
                                Responsible TBI Evaluation Team (Service/Clinic) Other:
                            </asp:Label>
                    </asp:TableCell>
                    <asp:TableCell>
                        <asp:TextBox runat="server" ID="TextBoxResponsibleTeamOther" 
                            TabIndex="49" 
                            Enabled="true" 
                            Visible="true"
                            Columns="40" 
                            MaxLength="250">
                        </asp:TextBox>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorResponsibleTeamOther" 
                            runat="server" 
                            TabIndex="50"
                            SetFocusOnError="true"
                            ValidationGroup="OnComplete"
                            ControlToValidate="TextBoxResponsibleTeamOther"
                            EnableClientScript="false"
                            ErrorMessage="Responsible TBI Evaluation Team (Service/Clinic) Other is required to move to completed status">
                        </asp:RequiredFieldValidator>
                    </asp:TableCell>
                </asp:TableRow>
                <tr>
                    <td>
                        <asp:Label ID="LabelforLabelReferralStatus" runat="server" 
                            AssociatedControlID="LabelReferralStatus" SkinID="DataLabel">Status:</asp:Label>
                    </td>
                    <td>
                        <asp:Label ID="LabelReferralStatus" runat="server" SkinID="DataLabel"></asp:Label>
                    </td>
                </tr>
            </table>                 
            <asp:Button ID="ButtonSave" UseSubmitBehavior = "true" TabIndex="51" Width="130px" runat="server" Text="Save" onclick="ButtonSave_Click" ToolTip="Save Changes" CausesValidation="true" style="cursor:hand" ValidationGroup="OnSave" />
            &nbsp;&nbsp;
            <asp:Button ID="ButtonCancel" UseSubmitBehavior="false" TabIndex="52" Width="130px" runat="server" SkinID = "CloseButton" onclick="ButtonClose_Click" ToolTip="Close referral without saving changes" CausesValidation="false" style="cursor:hand" />
            &nbsp;&nbsp;
            <asp:Button ID="ButtonComplete" UseSubmitBehavior = "true" TabIndex="53" Width="130px" runat="server" Text="Complete" onclick="ButtonComplete_Click" ToolTip="Save Changes and Complete Referral" CausesValidation="true" style="cursor:hand" ValidationGroup="OnComplete" />
            <asp:Button ID="ButtonReOpen" UseSubmitBehavior = "false" TabIndex="54" Width="130px" runat="server" Text="Re-Open Referral" onclick="ButtonReOpen_Click" ToolTip="Re-Open Referral to make changes" CausesValidation="false" style="cursor:hand" />
        </asp:Panel>
        <asp:HiddenField ID="HiddenFieldBreadCrumbBaseText" runat="server" />
        <asp:HiddenField ID="FormIsReadOnly" runat="server" />
    <asp:HiddenField ID="HiddenFieldDisplaySaveErrorList" runat="server" />
    <asp:Panel ID="PanelNoAccess" runat="server" Visible="false" Width="65%">
            You do not have access to the referral id supplied.
            <br /><br />
            Please contact the Registry Manager to grant access or verify that your permissions are correct.
    </asp:Panel>
    <asp:Panel ID="PanelReferralIdNotFound" runat="server" Visible="false" Width="65%">
            No record found for the referral ID supplied.
            <br />
            <br />
            If you tried accessing using a link within an email or typed the link in the browser, please check the link to ensure you have supplied a correct id.
    </asp:Panel>       
</asp:Content>

