﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web.Security;
using System.Web.UI.WebControls.WebParts;
using System.Text;
using System.IO;
using System.Reflection;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessManager.TBI;

public partial class PolyTraumaTracking : BasePage
{
    #region Variable Declarations

    //TBIExceptionHandler _tbiexception = new TBIExceptionHandler();

    #endregion

    #region Public Overrides

    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "TBI POLYTRAUMA";
    }

    public override string AppObjectCode()
    {
        return "TBI POLYTRAUMA LIST";
    }

    #endregion

    #region Protected Methods

    protected void Page_Load(object sender, EventArgs e)
    {

        ddlPolyTraumaEntryType.DataBound += new EventHandler(ddlPolyTraumaEntryType_DataBound);
        
       

    }

    void ddlPolyTraumaEntryType_DataBound(object sender, EventArgs e)
    {
        //Prevent the BOTH entry type from showing up in this menu
        for (int i = ddlPolyTraumaEntryType.Items.Count - 1; i >= 0; i--)
        {
            if (ddlPolyTraumaEntryType.Items[i].Text == "BOTH" && ddlPolyTraumaEntryType.Items[i].Value == "3")
                ddlPolyTraumaEntryType.Items.RemoveAt(i);
        }
    }

    protected void GridViewPolyTraumaEntries_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        try
        {
            if (e.CommandName == "Details")
            {
                int trauma_id = 0;
                if (e != null)
                {
                    if (e.CommandArgument != null)
                    {
                        trauma_id = Convert.ToInt32(e.CommandArgument);
                        GridViewPolyTraumaEntries.SelectedIndex = trauma_id;
                        if (GridViewPolyTraumaEntries.SelectedValue != null)
                        {
                            //int trauma_id = Convert.ToInt32(GridViewPolyTraumaEntries.SelectedValue);
                            trauma_id = int.Parse(GridViewPolyTraumaEntries.SelectedValue.ToString());
                        }
                    }
                }
                Response.Redirect(string.Format("PolyTraumaEntry.aspx?id={0}", trauma_id), false);
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, "PolyTraumaEntries", "100003", "GridViewPolyTraumaEntries_RowCommand()");
        } 
    }

    protected void ButtonDownloadToExcel_Click(object sender, EventArgs e)
    {
        try
        {
            PolyTraumaEntriesManager PolyTraumaManager = new PolyTraumaEntriesManager();

            int countAllPolyTrauma = PolyTraumaManager.SelectDownLoadViewByPolyTraumaVAMCCount(Helpers.getIntFromString(DropDownListPolyTraumaVAMC.SelectedValue), Helpers.getIntFromString(ddlPolyTraumaEntryType.SelectedValue), "", 0, 0);

            GridViewDownloadToExcel.PageSize = countAllPolyTrauma;
            GridViewDownloadToExcel.AutoGenerateColumns = true;
            GridViewDownloadToExcel.DataSourceID = "ObjectDataSourceDownLoadViewByPolyTraumaVAMC";
            GridViewDownloadToExcel.DataBind();
            GridViewDownloadToExcel.Visible = true;
                       

            ExportGridViewToExcel(GridViewDownloadToExcel, "Polytrauma Entries.xls");

            GridViewDownloadToExcel.Visible = false;
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, "PolyTraumaEntries", "100003", "ButtonDownloadToExcel_Click()");
        }
    }

    protected void ddlPolyTraumaEntryType_OnSelectedIndexChanged(object sender, EventArgs e)
    {
        GridViewPolyTraumaEntries.PageIndex = 0;
    }

    protected void DropDownListPolyTraumaVAMC_OnSelectedIndexChanged(object sender, EventArgs e)
    {
        GridViewPolyTraumaEntries.PageIndex = 0;

    }
    protected string GetStatusDescriptionFromCode(int code)
    {
        /*Expr*/
        var statusDescription = VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists.GetMilitartyServiceStatusList().Where(x => x.ID == code).Select(x => x.NAME).FirstOrDefault();

        return statusDescription;
        /*end expr*/
    }

    protected string GetDutyStatusDischargeDescriptionFromCode(int code)
    {
        /*Expr*/
        var statusDescription = VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists.GetTBIDischargeStatusList().Where(x => x.ID == code).Select(x => x.NAME).FirstOrDefault();

        return statusDescription;
        /*end expr*/
    }

    #endregion

    #region Commented Code
    //protected void GridViewPolyTraumaEntries_RowDataBound(object sender, GridViewRowEventArgs e)
    //{
    //GridView gridView = (GridView)sender;

    //if (e.Row.RowType == DataControlRowType.Header)
    //{
    //    int cellIndex = -1;
    //    foreach (DataControlField field in gridView.Columns)
    //    {
    //        e.Row.Cells[gridView.Columns.IndexOf(field)].CssClass = "sortableGridviewHeaderStyle";

    //        if (field.SortExpression == gridView.SortExpression)
    //        {
    //            cellIndex = gridView.Columns.IndexOf(field);
    //        }
    //    }

    //    if (cellIndex > -1)
    //    {
    //        //  this is a header row,
    //        //  set the sort style
    //        e.Row.Cells[cellIndex].CssClass =
    //            gridView.SortDirection == SortDirection.Ascending
    //            ? "sortableGridviewHeaderStyleSortAsc" : "sortableGridviewHeaderStyleSortDesc";
    //    }
    //}
    //}

    //protected void GridViewPolyTraumaEntries_RowCreated(object sender, GridViewRowEventArgs e) 
    //{
    //if (e.Row != null && e.Row.RowType == DataControlRowType.Header) 
    //{
    //    foreach (TableCell cell in e.Row.Cells) 
    //    {
    //        if (cell.HasControls()) 
    //        {
    //            LinkButton button = cell.Controls[0] as LinkButton; 
    //            HtmlGenericControl gv = new HtmlGenericControl("div");

    //            Label lnkName = new Label();
    //            lnkName.Text = button.Text + "&nbsp;&nbsp;&nbsp;";

    //            if (button != null) 
    //            {
    //                Image imageSort = new Image(); imageSort.ImageUrl = "~/images/GridSortArrowUp.gif";

    //                if (GridViewPolyTraumaEntries.SortExpression == button.CommandArgument) 
    //                {
    //                    if (GridViewPolyTraumaEntries.SortDirection == SortDirection.Ascending)
    //                    {
    //                        imageSort.ImageUrl = "~/images/GridSortArrowDown.gif";
    //                        imageSort.AlternateText = " Sort Descending ";
    //                    }
    //                    else
    //                    {
    //                        imageSort.ImageUrl = "~/images/GridSortArrowUp.gif";
    //                        imageSort.AlternateText = " Sort Ascending ";
    //                    }
    //                }

    //                gv.Controls.Add(lnkName);
    //                gv.Controls.Add(imageSort);

    //                button.Controls.Add(gv);

    //                //cell.Controls.Add(imageSort);
    //            }
    //        }
    //    }
    //}

    //for AddClickableSortImage
    //if (e.Row.RowType == DataControlRowType.Header) 
    //{
    //    AddClickableSortImage(GridViewPolyTraumaEntries, e.Row);
    //}
    //}

    //--adds a clickable image to indicate the sort direction for sortable columns
    //--gridview sorting should be enabled for this to work correctly
    //--within the the GridView_RowCreated Event put the following
    //protected void AddClickableSortImage(GridView grid, GridViewRow item)
    //{

    //    string col = ""; //--column name for sorting

    //    for (int i = 0; i <= grid.Columns.Count -1; i++)
    //    {
    //        col = grid.Columns[i].SortExpression;

    //        //--check to make sure this is a sortable column
    //        if (col != "")
    //        {
    //            //--create new image buttons and labels for the header
    //            Label HeaderLabel = new Label();
    //            Label BlankLabel = new Label();
    //            ImageButton imgBtnUp = new ImageButton();
    //            ImageButton imgBtnDown = new ImageButton();

    //            //--set the properties
    //            HeaderLabel.Text = grid.Columns[i].HeaderText + " ";
    //            BlankLabel.Text = "   ";     //--create a "gap" between sorting images

    //            imgBtnUp.PostBackUrl = Request.Path + "?LocID=" + (string)Request.QueryString["LocID"] + "&col=" + col + "&sort=asc";
    //            imgBtnUp.ImageUrl = "~/images/GridSortArrowUp.gif";
    //            imgBtnUp.Click +=new ImageClickEventHandler(SortImageClick);

    //            imgBtnDown.PostBackUrl = Request.Path + "?LocID=" + (string)Request.QueryString["LocID"] + "+col=" + col + "+sort=desc";
    //            imgBtnDown.ImageUrl = "~/images/GridSortArrowDown.gif";
    //            imgBtnDown.Click +=new ImageClickEventHandler(SortImageClick);

    //            //--this will remove the clickable column header link button that is automatically created
    //            //--when adding sorting capabilities to a gridview
    //            item.Cells[i].Controls.RemoveAt(0);

    //            //--add the new controls to the column header
    //            item.Cells[i].Controls.Add(HeaderLabel);
    //            item.Cells[i].Controls.Add(imgBtnUp);
    //            item.Cells[i].Controls.Add(BlankLabel);
    //            item.Cells[i].Controls.Add(imgBtnDown);
    //        }

    //    }
    //}

    ////--click event handler for the image buttons for gridview sorting
    //void SortImageClick(object sender, ImageClickEventArgs e)
    //{
    //    if (Request.QueryString["col"].ToString() != "")
    //    {
    //        if (Request.QueryString["sort"].ToString() == "asc" )
    //        {
    //            //GridView1.Sort(Request.QueryString["col"], SortDirection.Ascending)
    //            GridViewPolyTraumaEntries.Sort(Request.QueryString["col"], SortDirection.Ascending);
    //        }
    //        else
    //        {
    //            //GridView1.Sort(Request.QueryString["col"], SortDirection.Descending)
    //            GridViewPolyTraumaEntries.Sort(Request.QueryString["col"], SortDirection.Descending);
    //        }

    //    }
    //}

    //public string DataTable2ExcelString(System.Data.DataTable dt)
    //{
    //    StringBuilder sbTop = new StringBuilder();
    //    sbTop.Append("<html xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:x=\"urn:schemas-microsoft-com:office:excel\" ");
    //    sbTop.Append("xmlns=\"http://www.w3.org/TR/REC-html40\"><head><meta http-equiv=Content-Type content=\"text/html; charset=windows-1252\">");
    //    sbTop.Append("<meta name=ProgId content=Excel.Sheet><meta name=Generator content=\"Microsoft Excel 9\"><!--[if gte mso 9]>");
    //    sbTop.Append("<xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>" + dt.TableName + "</x:Name><x:WorksheetOptions>");
    //    sbTop.Append("<x:Selected/><x:ProtectContents>False</x:ProtectContents><x:ProtectObjects>False</x:ProtectObjects>");
    //    sbTop.Append("<x:ProtectScenarios>False</x:ProtectScenarios></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets>");
    //    sbTop.Append("<x:ProtectStructure>False</x:ProtectStructure><x:ProtectWindows>False</x:ProtectWindows></x:ExcelWorkbook></xml>");
    //    sbTop.Append("<![endif]--></head><body><table>");
    //    string bottom = "</table></body></html>";
    //    StringBuilder sb = new StringBuilder();
    //    //Header
    //    sb.Append("<tr>");
    //    for (int i = 0; i < dt.Columns.Count; i++)
    //    {
    //        sb.Append("<td>" + dt.Columns[i].ColumnName + "</td>");
    //    }
    //    sb.Append("</tr>");

    //    //Items
    //    for (int x = 0; x < dt.Rows.Count; x++)
    //    {
    //        sb.Append("<tr>");
    //        for (int i = 0; i < dt.Columns.Count; i++)
    //        {
    //            sb.Append("<td>" + dt.Rows[x][i] + "</td>");
    //        }
    //        sb.Append("</tr>");
    //    }

    //    string SSxml = sbTop.ToString() + sb.ToString() + bottom;

    //    return SSxml;
    //}
    //public override void VerifyRenderingInServerForm(Control control)
    //{
    //}


    //private void PrepareGridViewForExport(Control gv)
    //{

    //    Literal l = new Literal();

    //    for (int i = 0; i < gv.Controls.Count; i++)
    //    {

    //        if ((null != htControls[gv.Controls[i].GetType().Name]) || (null != htControls[gv.Controls[i].GetType

    //           ().BaseType.Name]))
    //        {

    //            l.Text = GetControlPropertyValue(gv.Controls[i]);

    //            gv.Controls.Remove(gv.Controls[i]);

    //            gv.Controls.AddAt(i, l);

    //        }

    //        if (gv.Controls[i].HasControls())
    //        {

    //            PrepareGridViewForExport(gv.Controls[i]);

    //        }

    //    }

    //}

    //private string GetControlPropertyValue(Control control)
    //{

    //    Type controlType = control.GetType();

    //    string strControlType = controlType.Name;

    //    string strReturn = "Error";

    //    bool bReturn;



    //    PropertyInfo[] ctrlProps = controlType.GetProperties();

    //    string ExcelPropertyName = (string)htControls[strControlType];

    //    if (ExcelPropertyName == null)
    //    {

    //        ExcelPropertyName = (string)htControls[control.GetType().BaseType.Name];

    //        if (ExcelPropertyName == null)

    //            return strReturn;

    //    }

    //    foreach (PropertyInfo ctrlProp in ctrlProps)
    //    {

    //        if (ctrlProp.Name == ExcelPropertyName &&

    //        ctrlProp.PropertyType == typeof(String))
    //        {

    //            try
    //            {

    //                strReturn = (string)ctrlProp.GetValue(control, null);

    //                break;

    //            }

    //            catch
    //            {

    //                strReturn = "";

    //            }

    //        }

    //        if (ctrlProp.Name == ExcelPropertyName &&

    //        ctrlProp.PropertyType == typeof(bool))
    //        {

    //            try
    //            {

    //                bReturn = (bool)ctrlProp.GetValue(control, null);

    //                strReturn = bReturn ? "True" : "False";

    //                break;

    //            }

    //            catch
    //            {

    //                strReturn = "Error";

    //            }

    //        }

    //        if (ctrlProp.Name == ExcelPropertyName &&

    //        ctrlProp.PropertyType == typeof(ListItem))
    //        {

    //            try
    //            {

    //                strReturn = ((ListItem)(ctrlProp.GetValue(control, null))).Text;

    //                break;

    //            }

    //            catch
    //            {

    //                strReturn = "";

    //            }

    //        }

    //    }

    //    return strReturn;

    //}
    #endregion


}