﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.TBI;

public partial class Patients : BasePage
{
    PATIENT patient;
    PatientManager patientManager = new PatientManager();

    public override string TopMenuName()
    {
        return "Patients";
    }

    public override string MenuItemName()
    {
        return "TBI PATIENTS";
    }

    public override string AppObjectCode()
    {
        return "TBI PATIENTS";
    }
  
    protected void Page_Load(object sender, EventArgs e)
    {

        if (!IsPostBack)
        {
            //if page is loading for first time get ID from querystring and set to hidden field to use on postbacks
            int? entryID = Convert.ToInt32(Request.QueryString["id"]);
            HiddenFieldEntryID.Value = entryID.GetValueOrDefault().ToString();

            //Check if the request is to start a new item 
            //a new item page request is signified when the querystring parameter id equals zero or is not present
            if (entryID == null || entryID == 0)
            {
                //set entryID to zero so that a default linq entity will be instantiated 
                entryID = 0;

                //if a patient id is not requested, display patient search and hide all others panels
                PanelNoInsertAllowed.Visible = false;
                PanelSelectPatient.Visible = true;
                PanelPatient.Visible = false;
            }
            else
            {
                //if patient id is requested hide patient search, show patient panel
                PanelSelectPatient.Visible = false;
                PanelPatient.Visible = true;

                //Modify breadcrumb to display adding new
                LabelBreadCrumb.Text = LabelBreadCrumb.Text + " > Patient ID : " + entryID;
            }
        }

        //only query for patient if determined that a patient id is being requested.
        if (PanelPatient.Visible == true)
        {
            //Create Patient Entity object and Set properties to state of form
            getEntry(Convert.ToInt32(HiddenFieldEntryID.Value));
        }
        
        if (IsPostBack)
        {
            LoadObjectFromControls();
        }
    }

    protected void getEntry(int id)
    {
        patient = patientManager.SelectByID(id);

        //initial display panels
        PanelNoAccess.Visible = false;
        PanelIdNotFound.Visible = false;
        PanelObjectContent.Visible = false;

        if (patient == null)
        {
            PanelObjectContent.Visible = false;

            if (patientManager.PatientExists(id))
            {
                PanelNoAccess.Visible = true;
            }
            else
            {
                PanelIdNotFound.Visible = true;
            }
        }
        else
        {
            PanelObjectContent.Visible = true;

            ObjectDataSourceTBIReferrals.DataBind();
        }
    }

    

    void Page_PreRender(object sender, EventArgs e)
    {
        if (patient != null)
        {
            //This is the last event in the page life cycle where changes can be made to the page object
            //so enforce business rules on the object (which could possibly change the propertie of the object
            //then load the form controls from the object

            //Enforce business rules on the referral object
            //need to call EnforceBusinessRules method in the ReferralManager because some rules require a database call
            //pass in the local instance of referral to the method.  The method will return the object with modifications due to business rules.
            if (IsPostBack)
            {
                int ret;
                ret = patientManager.EnforceBusinessRules(ref patient);
            }
        }

        if (!this.ReadOnly )
        {
        }

        //ButtonSave.Visible = (this.AllowUpdate);
    }


    #region Postback Events


    #endregion


    #region Object/Form Mapping

    private void LoadObjectFromControls()
    {
        //First Name
        //patient.FIRST_NAME = TextBoxFirstName.Text;

        //Gender
        //patient.STD_GENDER_ID = Helpers.getNullableIntFromString(DropDownListGender.SelectedValue);
    }

    #endregion
    
    protected void ButtonClose_Click(object sender, EventArgs e)
    {
        Response.Redirect("Patient.aspx");
    }

    protected void ButtonSearchPatient_Click(object sender, EventArgs e)
    {
        GridViewPatients.Visible = true;
        GridViewPatients.DataBind();
    }
    
    private string GetPageJavaScript()
    {
        StringBuilder myStringBuilder = new StringBuilder();
           
        return myStringBuilder.ToString();
    }

    protected bool SetOEFOIFCheckboxCheckedStatus(object dataItem, string columnName)
    {
        bool ret = false;

        //TO DO : Test this fix
        //if dataItem = "Y" return true else return false.
        if (DataBinder.Eval(dataItem, columnName) != null && (DataBinder.Eval(dataItem, columnName)).ToString() == "Y")
            ret = true;
        else // set to true
            ret = false;
        return ret;
    }
    protected void DropDownListVISN_SelectedIndexChanged(object sender, EventArgs e)
    {
        ObjectDataSourceStation.DataBind();
        DropDownListStation.Items.Clear();
        DropDownListStation.DataBind();
        DropDownListStation.Items.Insert(0, new ListItem("-- Select a Value --", "0"));
        DropDownListStation.SelectedIndex = 0;
    }
    
}
