﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.TBI;
using System.Text;

public partial class _Default : BasePage
{
    private UserAccountManager _user = (UserAccountManager)HttpContext.Current.User;

    protected void Page_Load(object sender, EventArgs e)
    {
        RedirectBasedOnUserRole();
    }
    public override string TopMenuName()
    {
        return "My Tasks";
    }
    public override string MenuItemName()
    {
        return "";
    }
    public override string AppObjectCode()
    {
        return "TBI DEFAULT";
    }

    /// <summary>
    /// This function sets Redirects based on the user role.
    /// </summary>
    private void RedirectBasedOnUserRole()
    {
        string defaultPage = MenuBuilder.GetDefaultPageForUserRole();

        if (defaultPage != "")
        {
            Response.Redirect(defaultPage);
        }
        
    }

}

