﻿using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.ComponentModel;


/// <summary>
/// Summary description for RequiredFieldValidatorForCheckBoxLists
/// </summary>
namespace CustomValidators
{
    public class RequiredFieldValidatorForCheckBoxLists :
                        BaseValidator
    {
        private ListControl _listctrl;

        public RequiredFieldValidatorForCheckBoxLists()
        {
            base.EnableClientScript = true;
        }

        protected override bool ControlPropertiesValid()
        {
            Control ctrl = FindControl(ControlToValidate);

            if (ctrl != null)
            {
                _listctrl = (ListControl)ctrl;
                return (_listctrl != null);
            }
            else
                return false;  // raise exception
        }
       
        protected override bool EvaluateIsValid()
        {
            //return _listctrl.SelectedIndex != -1 ;
            return EvaluateIsChecked();

        }

        private bool EvaluateIsChecked()
        {
            CheckBoxList _cbl = ((CheckBoxList)FindControl(ControlToValidate));
            foreach (ListItem li in _cbl.Items)
            {
                if (li.Selected)
                {
                    return true;
                }
            }
            return false;
        }
        
        
        protected override void OnPreRender(EventArgs e)
        {
            // Determines whether the validation control can be rendered
            // for a newer ("uplevel") browser.
            // check if client-side validation is enabled.

            base.OnPreRender(e);

            if (this.EnableClientScript)
            {
                //Page.ClientScript.RegisterExpandoAttribute(this.ClientID, "evaluationfunction", "CheckIfListChecked");
                this.CreateJavaScript();
            }

                    
        }

        protected void CreateJavaScript()
        {
            //StringBuilder sb = new StringBuilder();
            //sb.Append(@"<script type=""text/javascript"">function CheckIfListChecked(ctrl){");
            //sb.Append(@"var chkBoxList = document.getElementById(document.getElementById(ctrl.id).controltovalidate);");
            //sb.Append(@"var chkBoxCount= chkBoxList.getElementsByTagName(""input"");");
            //sb.Append(@"for(var i=0;i<chkBoxCount.length;i++){");
            //sb.Append(@"if(chkBoxCount.item(i).checked){");
            //sb.Append(@"return true; }");
            //sb.Append(@"}return false; ");
            //sb.Append(@"}</script>");
            //Page.ClientScript.RegisterClientScriptBlock(GetType(), "JSScript", sb.ToString());
            StringBuilder sb_Script = new StringBuilder();
            sb_Script.Append("<script language=\"javascript\">");
            sb_Script.Append("\r");
            sb_Script.Append("\r");
            sb_Script.Append("function cb_verify(sender) {");
            sb_Script.Append("\r");
            sb_Script.Append("var val = document.getElementById(document.getElementById"
                     + "(sender.id).controltovalidate);");
            sb_Script.Append("\r");
            sb_Script.Append("var col = val.getElementsByTagName(\"*\");");
            sb_Script.Append("\r");
            sb_Script.Append("if ( col != null ) {");
            sb_Script.Append("\r");
            sb_Script.Append("for ( i = 0; i < col.length; i++ ) {");
            sb_Script.Append("\r");
            sb_Script.Append("if (col.item(i).tagName == \"INPUT\") {");
            sb_Script.Append("\r");
            sb_Script.Append("if ( col.item(i).checked ) {");
            sb_Script.Append("\r");
            sb_Script.Append("\r");
            sb_Script.Append("return true;");
            sb_Script.Append("\r");
            sb_Script.Append("}");
            sb_Script.Append("\r");
            sb_Script.Append("}");
            sb_Script.Append("\r");
            sb_Script.Append("}");
            sb_Script.Append("\r");
            sb_Script.Append("\r");
            sb_Script.Append("\r");
            sb_Script.Append("return false;");
            sb_Script.Append("\r");
            sb_Script.Append("}");
            sb_Script.Append("\r");
            sb_Script.Append("}");
            sb_Script.Append("\r");
            sb_Script.Append("</script>");

            //Inject the script into the page
            Page.ClientScript.RegisterClientScriptBlock(GetType(), "SCRIPTBLOCK",
                             sb_Script.ToString());
            //Registering validator clientside javascript function
            Page.ClientScript.RegisterExpandoAttribute(ClientID, "evaluationfunction",
                             "cb_verify");

        }
    }
}
