﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using VeteransAffairs.Registries.Business;

namespace VeteransAffairs.Registries
{
    /// <summary>
    /// Summary description for QuestionChoiceRetriever
    /// </summary>
    public static class QuestionChoiceRetriever
    {
        private static readonly object sync = new object();
        private static VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager instrumentManager = null;
        private static int surveyID;

        public static void Reset(VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager instrumentManager, int surveyID)
        {
            lock (sync)
            {
                QuestionChoiceRetriever.instrumentManager = instrumentManager;
                QuestionChoiceRetriever.surveyID = surveyID;
                if (null == instrumentManager)
                    allQuestions = null;
            }
        }

        public static List<STD_QUESTION_CHOICE> GetQuestionChoices(string questionNumber)
        {
            lock (sync)
            {
                STD_QUESTION question = GetAllQuestionsForSurvey().FirstOrDefault(item => item.QUESTION_NUMBER == questionNumber);
                if (null == question) 
                    return new List<STD_QUESTION_CHOICE>();
                return question.STD_QUESTION_CHOICEs.OrderBy(item => item.CHOICE_SORT_ORDER).ToList();
            }
        }

        /// <summary>
        /// Provided for backward compatibility.
        /// </summary>
        /// <param name="questionNumber"></param>
        /// <param name="surveyTypeCode"></param>
        /// <returns></returns>
        public static List<STD_QUESTION_CHOICE> GetChoicesByQuestionNumberandSurveyType(string questionNumber, string surveyTypeCode)
        {
            return GetQuestionChoices(questionNumber);
        }

        public static List<STD_QUESTION> GetQuestions()
        {
            lock (sync)
            {
                return GetAllQuestionsForSurvey();
            }
        }

        private static List<STD_QUESTION> allQuestions = null;
        private static List<STD_QUESTION> GetAllQuestionsForSurvey()
        {
            if (null == allQuestions)
                allQuestions = instrumentManager.SelectAllQuestions(surveyID).ToList();
            return allQuestions;
        }

    }
}