﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using System.Text;

public partial class AdminEditUsersRoles : BasePage
{
    private string _currentRegistry = Helpers.GetConfigEntry("Registry");
    private UserAccountManager _currentUser = (UserAccountManager)HttpContext.Current.User;

    USER userEntry;
    UsersManager usersManager = new UsersManager();

    public override string MenuItemName()
    {
        return "TBI ADMIN USER ROLE";
    }

    public override string AppObjectCode()
    {
        return "TBI ADMIN USER ROLE";
    }

    public override string TopMenuName()
    {
        return "Administration";
    }


    public AdminEditUsersRoles()
    {
        //Manager Save Notification Event Handler
        usersManager.BOSaveSuccess += new BaseBO.BOSaveSuccessEvent(manager_BOSaveSuccess);
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        HiddenFieldRegistryName.Value = _currentRegistry;
              

        if (!IsPostBack)
        {
            HiddenFieldBreadCrumbBaseText.Value = LabelBreadCrumb.Text;
            
            //if page is loading for first time get ID from querystring and set to hidden field to use on postbacks
            int? userID = Convert.ToInt32(Request.QueryString["id"]);
            HiddenFieldUserID.Value = userID.GetValueOrDefault().ToString();

            //if userID is not supplied or zero then display a list of all user roles
            if (userID == null || userID == 0)
            {
                userID = 0;

                //set page display for list of all user roles
                SetFormDisplay(false);

            }
            else
            {
                //set page to display for single user role management
                SetFormDisplay(true);

            }

            if (_currentUser.IsInRole(16))
            {
                DisableVisnStationCheckBoxes();
            }
        }

        if (HiddenFieldUserID.Value != "0")
        {
            //Create User Entity object and Set properties to state of form
            getEntry(Convert.ToInt32(HiddenFieldUserID.Value));
        }


        if (IsPostBack && userEntry != null)
        {
            LoadObjectFromControls();
        }
    }

    private void DisableVisnStationCheckBoxes()
    {
        //CheckBoxRoleReportingVISN.Enabled = false;
        //CheckBoxRoleReportingUserStation.Enabled = false;
        //ListBoxReportingVISN.Enabled = false;
        //ListBoxReportingStation.Enabled = false;
    }

    protected void getEntry(int id)
    {
        userEntry = usersManager.SelectByID(_currentRegistry, id);

        //initial display panels
        PanelNoAccess.Visible = false;
        PanelIdNotFound.Visible = false;
        PanelObjectContent.Visible = false;

        if (userEntry == null)
        {
            PanelObjectContent.Visible = false;

            if (usersManager.UserIDExists(id))
            {
                PanelNoAccess.Visible = true;
            }
            else
            {
                PanelIdNotFound.Visible = true;
            }
        }
        else
        {
            PanelObjectContent.Visible = true;
        }
    }

    void Page_PreRender(object sender, EventArgs e)
    {
        if (userEntry != null)
        {
            //This is the last event in the page life cycle where changes can be made to the page object
            //so enforce business rules on the object (which could possibly change the propertie of the object
            //then load the form controls from the object

            //Enforce business rules on the referral object
            //need to call EnforceBusinessRules method in the ReferralManager because some rules require a database call
            //pass in the local instance of referral to the method.  The method will return the object with modifications due to business rules.
            if (IsPostBack)
            {
                int ret;
                ret = usersManager.EnforceBusinessRules(ref userEntry);
            }
            LoadControlsFromObject();
        }
    }

    #region Postback Events

    protected void ButtonSave_Click(object sender, EventArgs e)
    {
        int returnSaveValue = 0;

        returnSaveValue = usersManager.Update(userEntry);
        this.SuppressSaveMessage = false;
        this.IsSaveSuccess = (returnSaveValue > 0);

        //Set Broken Rule Error Display
        if (userEntry.BrokenRules.Count == 0)
        {
            ErrorList1.Visible = false;

        }
        else
        {
            ErrorList1.Visible = true;
        }

        ErrorList1.BrokenRules = userEntry.BrokenRules;
        
        //TO DO
        //Display Save Message

        //Refresh entity root data
        if (returnSaveValue != 0)
        {
            getEntry(Convert.ToInt32(returnSaveValue));
            var master = (RegistryMaster)Master;
            master.SetDirtyFlag(false);
            //(this.Master as RegistryMaster).SetDirtyFlag(false);
        }
    }
    protected void ButtonClose_Click(object sender, EventArgs e)
    {
        Response.Redirect("AdminListUsers.aspx");
    }
    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        this.TextBoxSearchCriteria.Text = "";
        SetFormDisplay(true);
    }
    protected void ButtonSearch_Click(object sender, EventArgs e)
    {
      
        userEntry = usersManager.SelectByUsername(TextBoxSearchCriteria.Text);

        if (userEntry != null)
        {
            GridViewUserRoles.DataSourceID = "ObjectDataSourceUsersRoles";
            GridViewUserRoles.DataBind();
        }

    }
    protected void SetFormDisplay(bool isSingleUserRoleManagement)
    {
        LabelBreadCrumb = (Label)Master.FindControl("LabelBreadCrumb");

        if (isSingleUserRoleManagement)
        {
            //set page to display for single user role management
            PanelListUserRoles.Visible = false;
            PanelRoleInformation.Visible = true;

            //Modify breadcrumb to display editing user id
            LabelBreadCrumb.Text = HiddenFieldBreadCrumbBaseText.Value + " > Edit Roles for User ID : " + HiddenFieldUserID.Value;

        }
        else
        {
            //set page display for list of all user roles
            PanelListUserRoles.Visible = true;
            PanelRoleInformation.Visible = false;

            //Modify breadcrumb to display adding new
            LabelBreadCrumb.Text = HiddenFieldBreadCrumbBaseText.Value + " > List all User / Roles ";
            
        }
    }
    protected void CheckBoxRoleTBIEditor_CheckedChanged(object sender, EventArgs e)
    {
        //if (CheckBoxRoleTBIEditor.Checked)
        //{
        //    USER_ROLE userRole = new USER_ROLE();
        //    userRole.STD_ROLE_ID = (int)RoleCode.TBI_EDITOR;
        //    userEntry.USER_ROLEs.Add(userRole);
        //}

        ListBoxVISNsEditor.Enabled = CheckBoxRoleTBIEditor.Checked;
    }
    protected void CheckBoxRoleTBIReadOnly_CheckedChanged(object sender, EventArgs e)
    {
        //if (CheckBoxRoleTBIReadOnly.Checked)
        //{
        //    USER_ROLE userRole = new USER_ROLE();
        //    userRole.STD_ROLE_ID = (int)RoleCode.TBI_READ_ONLY;
        //    userEntry.USER_ROLEs.Add(userRole);
        //}

        ListBoxVISNsReadOnly.Enabled = CheckBoxRoleTBIReadOnly.Checked;
    }
    protected void CheckBoxRoleReportingVISN_CheckedChanged(object sender, EventArgs e)
    {
        //if (CheckBoxRoleReportingVISN.Checked)
        //{
        //    USER_ROLE userRole = new USER_ROLE();
        //    userRole.STD_ROLE_ID = (int)RoleCode.TBI_REPORTING_USER_VISN;
        //    userEntry.USER_ROLEs.Add(userRole);
        //}

        if (!CheckBoxRoleReportingVISN.Checked)
        {
            UnselectListBoxItems(ListBoxReportingVISN);
        }

        ListBoxReportingVISN.Enabled = CheckBoxRoleReportingVISN.Checked;
    }
    protected void CheckBoxRoleReportingUserStation_CheckedChanged(object sender, EventArgs e)
    {
        //if (CheckBoxRoleReportingUserStation.Checked)
        //{
        //    USER_ROLE userRole = new USER_ROLE();
        //    userRole.STD_ROLE_ID = (int)RoleCode.TBI_REPORTING_USER_STATION;
        //    userEntry.USER_ROLEs.Add(userRole);
        //}

        if (!CheckBoxRoleReportingVISN.Checked)
        {
            UnselectListBoxItems(ListBoxReportingStation);
        }

        ListBoxReportingStation.Enabled = CheckBoxRoleReportingUserStation.Checked;
    }
    protected void CheckBoxRolePolyEditor_CheckedChanged(object sender, EventArgs e)
    {
        ListBoxVISNsPolyEditor.Enabled = CheckBoxRolePolyEditor.Checked;
    }
    protected void CheckBoxRolePolyReadOnly_CheckedChanged(object sender, EventArgs e)
    {
        ListBoxVISNsPolyReadOnly.Enabled = CheckBoxRolePolyReadOnly.Checked;
    }
    protected void CheckBoxRoleReportingNational_CheckedChanged(object sender, EventArgs e)
    {
        if( CheckBoxRoleReportingNational.Checked )
        {
            CheckBoxRoleReportingVISN.Checked = false;
            CheckBoxRoleReportingUserStation.Checked = false;

            CheckBoxRoleReportingVISN.Enabled = false;
            CheckBoxRoleReportingUserStation.Enabled = false;

            ListBoxReportingVISN.Enabled = false;
            ListBoxReportingStation.Enabled = false;

            UnselectListBoxItems(ListBoxReportingVISN);
            UnselectListBoxItems(ListBoxReportingStation);
        }
        else
        {
            CheckBoxRoleReportingVISN.Enabled = true;
            CheckBoxRoleReportingUserStation.Enabled = true;

            ListBoxReportingVISN.Enabled = true;
            ListBoxReportingStation.Enabled = true;
        }
    }

    #endregion

    #region Object/Form Mapping

    private void LoadControlsFromObject()
    {
        //Registry
        HiddenFieldRegistryName.Value = _currentRegistry;

        //TO DO : modify drop down population to add archived item if persisted in entity 
        //          and remove "-- Select a Value --" when an item is selected and field is not nullable 

        //Username:
        LabelUsername.Text = userEntry.USERNAME;

        //Full Name:
        LabelFullName.Text = userEntry.FULL_NAME;
        
        //Employee Number:
        LabelEmployeeNumber.Text = userEntry.EMPLOYEE_NUMBER;

        //Job Title:
        LabelJobTitle.Text = userEntry.JOB_TITLE;

        //userid 
        HiddenFieldUserID.Value = userEntry.USER_ID.ToString();

        //User Roles
        
        //JH 9/30/2009 commenting out this section - old style of role display
        //foreach (USER_ROLE userRole in userEntry.USER_ROLEs)
        //{
        //    ListItem foundListItem = CheckBoxListUserRoles.Items.FindByValue(userRole.STD_ROLE_ID.ToString());

        //    if (foundListItem != null)
        //    {
        //        foundListItem.Selected = true;
        //    }
        //}

        //CheckBoxRoleAdministrator.Checked = false;
        //CheckBoxRoleTBIEditor.Checked = false;
        //CheckBoxRoleTBIReadOnly.Checked = false;
        //CheckBoxRolePolyEditor.Checked = false; 
        //CheckBoxRolePolyReadOnly.Checked = false; 
        //CheckBoxRoleReportingNational.Checked = false; 
        //CheckBoxRoleReportingVISN.Checked = false; 
        //CheckBoxRoleReportingUserStation.Checked = false; 

        foreach (USER_ROLE userRole in userEntry.USER_ROLEs)
        {

            //8 TBI Administrator 
            //10 TBI Editor 
            //13 TBI Read Only 
            //11 TBI PolyTrauma Editor 
            //15 TBI PolyTrauma Read Only 
            //16 TBI Reporting User National 
            //17 TBI Reporting User VISN 
            //18 TBI Reporting User Station 

            switch (userRole.STD_ROLE_ID)
            {
                case (int)RoleCode.TBI_ADMINISTRATOR: //8
                    CheckBoxRoleAdministrator.Checked = true;
                    break;
                case (int)RoleCode.TBI_EDITOR: //10
                    CheckBoxRoleTBIEditor.Checked = true;
                    //ListBoxVISNsEditor.Enabled = true;
                    break;
                case (int)RoleCode.TBI_READ_ONLY: //13
                    CheckBoxRoleTBIReadOnly.Checked = true;
                    //ListBoxVISNsReadOnly.Enabled = true;
                    break;
                case (int)RoleCode.TBI_POLYTRAUMA_EDITOR: //11
                    CheckBoxRolePolyEditor.Checked = true;
                    //ListBoxVISNsPolyEditor.Enabled = true;
                    break;
                case (int)RoleCode.TBI_POLYTRAUMA_READ_ONLY: //15
                    CheckBoxRolePolyReadOnly.Checked = true;
                    //ListBoxVISNsPolyReadOnly.Enabled = true;
                    break;
                case (int)RoleCode.TBI_REPORTING_USER_NATIONAL: //16
                    CheckBoxRoleReportingNational.Checked = true;
                    break;
                case (int)RoleCode.TBI_REPORTING_USER_VISN: //17
                    CheckBoxRoleReportingVISN.Checked = true;
                    //ListBoxReportingVISN.Enabled = true;
                    break;
                case (int)RoleCode.TBI_REPORTING_USER_STATION: //18
                    CheckBoxRoleReportingUserStation.Checked = true;
                    //ListBoxReportingStation.Enabled = true;
                    break;
                case (int)RoleCode.TBI_REHABILIATION_AND_POLYTRAUMA_CLINICIANS: //413  or 417(50/20)
                    CheckBoxRehabilitationAndPolytraumaClinicians.Checked = true;
                    break;
                case (int)RoleCode.TBI_TECHNICAL_SUPPORT_ADMINISTRATOR: //416
                    CheckBoxTBITechnicalSupportAdministrator.Checked = true;
                    break;
             }
        }

        //VISNs for editor
        if (CheckBoxRoleTBIEditor.Checked == true)
        {
            ListBoxVISNsEditor.DataBind();
        
            foreach (USER_ROLE userRole in userEntry.USER_ROLEs)
            {
                if (userRole.STD_ROLE_ID == (int)RoleCode.TBI_EDITOR)
                {
                    ListItem foundListItem = ListBoxVISNsEditor.Items.FindByValue(userRole.STD_INSTITUTION_ID.ToString());

                    if (foundListItem != null)
                    {
                        foundListItem.Selected = true;
                    }
                }
            }
        }

        //VISNs for readonly
        if (CheckBoxRoleTBIReadOnly.Checked == true)
        {
            ListBoxVISNsReadOnly.DataBind();
        
            foreach (USER_ROLE userRole in userEntry.USER_ROLEs)
            {
                if (userRole.STD_ROLE_ID == (int)RoleCode.TBI_READ_ONLY)
                {
                    ListItem foundListItem = ListBoxVISNsReadOnly.Items.FindByValue(userRole.STD_INSTITUTION_ID.ToString());

                    if (foundListItem != null)
                    {
                        foundListItem.Selected = true;
                    }
                }
            }
        }

        //VISNs for Poly Editor 
        if (CheckBoxRolePolyEditor.Checked == true)
        {
            ListBoxVISNsPolyEditor.DataBind();

            foreach (USER_ROLE userRole in userEntry.USER_ROLEs)
            {
                if (userRole.STD_ROLE_ID == (int)RoleCode.TBI_POLYTRAUMA_EDITOR)
                {
                    ListItem foundListItem = ListBoxVISNsPolyEditor.Items.FindByValue(userRole.STD_INSTITUTION_ID.ToString());

                    if (foundListItem != null)
                    {
                        foundListItem.Selected = true;
                    }
                }
            }
        }

        //VISNs for Poly Read Only 
        if (CheckBoxRolePolyReadOnly.Checked == true)
        {
            ListBoxVISNsPolyReadOnly.DataBind();

            foreach (USER_ROLE userRole in userEntry.USER_ROLEs)
            {
                if (userRole.STD_ROLE_ID == (int)RoleCode.TBI_POLYTRAUMA_READ_ONLY)
                {
                    ListItem foundListItem = ListBoxVISNsPolyReadOnly.Items.FindByValue(userRole.STD_INSTITUTION_ID.ToString());

                    if (foundListItem != null)
                    {
                        foundListItem.Selected = true;
                    }
                }
            }
        }


        //VISNs for Reporting VISN
        if (CheckBoxRoleReportingVISN.Checked == true)
        {
            ListBoxReportingVISN.DataBind();

            foreach (USER_ROLE userRole in userEntry.USER_ROLEs)
            {
                if (userRole.STD_ROLE_ID == (int)RoleCode.TBI_REPORTING_USER_VISN)
                {
                    ListItem foundListItem = ListBoxReportingVISN.Items.FindByValue(userRole.STD_INSTITUTION_ID.ToString());

                    if (foundListItem != null)
                    {
                        foundListItem.Selected = true;
                    }
                }
            }
        }    

        //VISNs for Reporting Station
        if (CheckBoxRoleReportingUserStation.Checked == true)
        {
            ListBoxReportingStation.DataBind();

            foreach (USER_ROLE userRole in userEntry.USER_ROLEs)
            {
                if (userRole.STD_ROLE_ID == (int)RoleCode.TBI_REPORTING_USER_STATION)
                {
                    ListItem foundListItem = ListBoxReportingStation.Items.FindByValue(userRole.STD_INSTITUTION_ID.ToString());

                    if (foundListItem != null)
                    {
                        foundListItem.Selected = true;
                    }
                }
            }
        }
    }

    private void LoadObjectFromControls()
    {

        //User Roles

        //JH 9/30/2009 commenting out section - old way of displaying/saving roles
        //foreach (ListItem checkboxListRole in CheckBoxListUserRoles.Items)
        //{
        //    //for each item in the check box list check if it is an entity in 
        //    TBI_INJURY_DETAIL existingInjury = (from e in polyTraumEntry.TBI_INJURY_DETAILs
        //                                        where e.STD_TBIINJURYLIST_ID == Helpers.getIntFromString(checkboxListRole.Value)
        //                                        select e).FirstOrDefault();

        //    //check if the checkboxlist item was selected,  
        //    if (checkboxListRole.Selected)
        //    {
        //        //if the item is selected then it needs to be in TBI_INJURY_DETAILs
        //        //if the entity exists, that signifies the item is already in TBI_INJURY_DETAILs therefore nothing needs to be done. 
        //        if (existingInjury == null)
        //        {
        //            TBI_INJURY_DETAIL newInjury = new TBI_INJURY_DETAIL();
        //            newInjury.TBI_POLYTRAUMA_ID = polyTraumEntry.TBI_POLYTRAUMA_ID;
        //            newInjury.STD_TBIINJURYLIST_ID = Helpers.getIntFromString(checkboxListRole.Value);

        //            polyTraumEntry.TBI_INJURY_DETAILs.Add(newInjury);
        //        }
        //    }
        //    else
        //    {
        //        //if the item is not selected, then it needs to be taken out of TBI_INJURY_DETAILs if it is in the list
        //        if (existingInjury != null)
        //        {
        //            existingInjury.SetAsDeleteOnSubmit();
        //            //polyTraumEntry.TBI_INJURY_DETAILs.Remove(existingInjury);
        //        }
        //    }
        //}


        //Remove USER Role Entries as needed  
        if (CheckBoxRoleAdministrator.Checked == false)
        {
            userEntry.RemoveRoleFromUser(userEntry, (int)RoleCode.TBI_ADMINISTRATOR);
        }

        if (CheckBoxRoleTBIEditor.Checked == false)
        {
            userEntry.RemoveRoleFromUser(userEntry, (int)RoleCode.TBI_EDITOR);
        }
        
        if (CheckBoxRoleTBIReadOnly.Checked == false)
        {
            userEntry.RemoveRoleFromUser(userEntry, (int)RoleCode.TBI_READ_ONLY);
        }
        
        if (CheckBoxRolePolyEditor.Checked == false)
        {
             userEntry.RemoveRoleFromUser(userEntry, (int)RoleCode.TBI_POLYTRAUMA_EDITOR);
        }

        if (CheckBoxRolePolyReadOnly.Checked == false)
        {
            userEntry.RemoveRoleFromUser(userEntry, (int)RoleCode.TBI_POLYTRAUMA_READ_ONLY);
        }
        
        if (CheckBoxRoleReportingNational.Checked == false)
        {
            userEntry.RemoveRoleFromUser(userEntry, (int)RoleCode.TBI_REPORTING_USER_NATIONAL);
        }
        
        if (CheckBoxRoleReportingVISN.Checked == false)
        {
            userEntry.RemoveRoleFromUser(userEntry, (int)RoleCode.TBI_REPORTING_USER_VISN);
        }
        
        if (CheckBoxRoleReportingUserStation.Checked == false)
        {
            userEntry.RemoveRoleFromUser(userEntry, (int)RoleCode.TBI_REPORTING_USER_STATION);
        }

        if (CheckBoxRehabilitationAndPolytraumaClinicians.Checked == false)
        {
            userEntry.RemoveRoleFromUser(userEntry, (int)RoleCode.TBI_REHABILIATION_AND_POLYTRAUMA_CLINICIANS);
        }

        if (CheckBoxTBITechnicalSupportAdministrator.Checked == false)
        {
            userEntry.RemoveRoleFromUser(userEntry, (int)RoleCode.TBI_TECHNICAL_SUPPORT_ADMINISTRATOR);
        }

        //Add User Roles as needed

        //8 TBI Administrator 
        //10 TBI Editor 
        //13 TBI Read Only 
        //11 TBI PolyTrauma Editor 
        //15 TBI PolyTrauma Read Only 
        //16 TBI Reporting User National 
        //17 TBI Reporting User VISN 
        //18 TBI Reporting User Station 

        //8 TBI Administrator
        if (CheckBoxRoleAdministrator.Checked == true)
        {
            UpdateUserRoleNotVisnBased(userEntry, (int)RoleCode.TBI_ADMINISTRATOR);
        }

        //10 TBI Editor
        if (CheckBoxRoleTBIEditor.Checked == true)
        {
            UpdateUserRolesFromListBox(userEntry, ListBoxVISNsEditor, (int)RoleCode.TBI_EDITOR);
        }
                
        //13 TBI Read Only
        if (CheckBoxRoleTBIReadOnly.Checked == true)
        {
            UpdateUserRolesFromListBox(userEntry, ListBoxVISNsReadOnly, (int)RoleCode.TBI_READ_ONLY);
        }
        
        //11 TBI PolyTrauma Editor 
        if (CheckBoxRolePolyEditor.Checked == true)
        {
            //UpdateUserRoleNotVisnBased(userEntry, (int)RoleCode.TBI_POLYTRAUMA_EDITOR);
            UpdateUserRolesFromListBox(userEntry, ListBoxVISNsPolyEditor, (int)RoleCode.TBI_POLYTRAUMA_EDITOR);
        }

        //15 TBI PolyTrauma Read Only  
        if (CheckBoxRolePolyReadOnly.Checked == true)
        {
            //UpdateUserRoleNotVisnBased(userEntry, (int)RoleCode.TBI_POLYTRAUMA_READ_ONLY);
            UpdateUserRolesFromListBox(userEntry, ListBoxVISNsPolyReadOnly, (int)RoleCode.TBI_POLYTRAUMA_READ_ONLY);
        }

        //16 TBI Reporting User National  
        if (CheckBoxRoleReportingNational.Checked == true)
        {
            UpdateUserRoleNotVisnBased(userEntry, (int)RoleCode.TBI_REPORTING_USER_NATIONAL);
        }

        //17 TBI Reporting User VISN 
        if (CheckBoxRoleReportingVISN.Checked == true)
        {
            UpdateUserRolesFromListBox(userEntry, ListBoxReportingVISN, (int)RoleCode.TBI_REPORTING_USER_VISN);
        }

        //18 TBI Reporting User Station
        if (CheckBoxRoleReportingUserStation.Checked == true)
        {
            UpdateUserRolesFromListBox(userEntry, ListBoxReportingStation, (int)RoleCode.TBI_REPORTING_USER_STATION);
        }

        //413 TBI REHABILIATION AND POLYTRAUMA CLINICIANS
        if (CheckBoxRehabilitationAndPolytraumaClinicians.Checked == true)
        {
            UpdateUserRoleNotVisnBased(userEntry, (int)RoleCode.TBI_REHABILIATION_AND_POLYTRAUMA_CLINICIANS);
        }

        //416 TBI TECHNICAL SUPPORT ADMINISTRATOR
        if (CheckBoxTBITechnicalSupportAdministrator.Checked == true)
        {
            UpdateUserRoleNotVisnBased(userEntry, (int)RoleCode.TBI_TECHNICAL_SUPPORT_ADMINISTRATOR);
        }
    }

    private void UpdateUserRoleNotVisnBased(USER userEntity, int RoleID)
    {
        if (!userEntity.USER_ROLEs.Any(e => e.STD_ROLE_ID == RoleID && e.INACTIVE_FLAG == false))
        {
            USER_ROLE role = new USER_ROLE();
            role.STD_ROLE_ID = RoleID;
            role.STD_INSTITUTION_ID = STD_INSTITUTION.TopInstitutionId;
            userEntry.USER_ROLEs.Add(role);
        }
    }

    private void UpdateUserRolesFromListBox(USER userEntity, ListBox ListBoxVISNsEditor, int RoleID)
    {
        
        foreach (ListItem checkboxItem in ListBoxVISNsEditor.Items)
        {
            //for each item in the check box list check if it already exists in the entityset
            USER_ROLE existingRole = (from e in userEntity.USER_ROLEs
                                      where e.STD_ROLE_ID == RoleID
                                      && e.STD_INSTITUTION_ID == Helpers.getIntFromString(checkboxItem.Value)
                                      && e.INACTIVE_FLAG == false
                                      select e).FirstOrDefault();

            //check if the checkboxlist item was selected,  
            if (checkboxItem.Selected)
            {
                //if the item is selected then it needs to be in the set
                //if the entity exists, that signifies the item is already in the set therefore nothing needs to be done. 
                if (existingRole == null)
                {
                    USER_ROLE newUserRole = new USER_ROLE();
                    newUserRole.STD_ROLE_ID = RoleID;
                    newUserRole.STD_INSTITUTION_ID = Helpers.getIntFromString(checkboxItem.Value);

                    userEntry.USER_ROLEs.Add(newUserRole);
                }
            }
            else
            {
                //if the item is not selected, then it needs to be marked as inactive
                if (existingRole != null)
                {
                    //existingRole.INACTIVE_FLAG = true;
                    existingRole.SetAsDeleteOnSubmit();
                }
            }
        }
    }


    #endregion

    #region private methods

    private void UnselectListBoxItems(ListBox listBox)
    {
        foreach (ListItem item in listBox.Items)
        {
            item.Selected = false;
        }
    }
   //private string GetPageJavaScript()
    //{
    //    StringBuilder myStringBuilder = new StringBuilder();

    //    myStringBuilder.Append("var CheckBoxRoleTBIEditor = '" + CheckBoxRoleTBIEditor.ClientID + "';");
    //    myStringBuilder.Append("var ListBoxVISNsEditor = '" + ListBoxVISNsEditor.ClientID + "';");
    //    myStringBuilder.Append("var CheckBoxRoleTBIReadOnly = '" + CheckBoxRoleTBIReadOnly.ClientID + "';");
    //    myStringBuilder.Append("var ListBoxVISNsReadOnly = '" + ListBoxVISNsReadOnly.ClientID + "';");
    //    myStringBuilder.Append("var CheckBoxRoleReportingVISN = '" + CheckBoxRoleReportingVISN.ClientID + "';");
    //    myStringBuilder.Append("var ListBoxReportingVISN = '" + ListBoxReportingVISN.ClientID + "';");
    //    myStringBuilder.Append("var CheckBoxRoleReportingUserStation = '" + CheckBoxRoleReportingUserStation.ClientID + "';");
    //    myStringBuilder.Append("var ListBoxReportingStation = '" + ListBoxReportingStation.ClientID + "';");
    //    myStringBuilder.Append("");
    //    myStringBuilder.Append("function SetListBoxEnabledStatus(source, listboxname)");
    //    myStringBuilder.Append("{");
    //    myStringBuilder.Append("var listboxObj = document.getElementById(listboxname);");
    //    myStringBuilder.Append("if ($get(source).checked == true)");
    //    myStringBuilder.Append("{");
    //    myStringBuilder.Append("listboxObj.disabled = false;");
    //    myStringBuilder.Append("}");
    //    myStringBuilder.Append("else");
    //    myStringBuilder.Append("{");
    //    myStringBuilder.Append("listboxObj.disabled = true;");
    //    myStringBuilder.Append("}");
    //    myStringBuilder.Append("}");

    //    return myStringBuilder.ToString();

    //}

    #endregion


    protected void ButtonDownloadToExcel_Click(object sender, EventArgs e)
    {

        UsersManager usersManager = new UsersManager();

        int countAll = usersManager.SelectListUsersVISNsCount(HiddenFieldRegistryName.Value,"","",0,0);

        GridViewUserRoles.PageSize = countAll;

        GridViewUserRoles.DataBind();

        PrepareGridViewForExport(GridViewUserRoles);

        ExportGridViewToExcel(GridViewUserRoles, "TBI User Roles.xls");

    }

}

