package gov.va.med.domain.fee;

import java.io.Serializable;
import javax.persistence.*;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/**
 * The persistent class for the CLAIM_PROCEDURE_OHI database table.
 * 
 */
@Entity(name = "fClaimProcedureOhi")
@Table(name = "CLAIM_PROCEDURE_OHI")
public class ClaimProcedureOhi implements Serializable {
	private static final long serialVersionUID = 1L;

	private long claimProcOhiId;
	ClaimProcedure claimProcedure;
	private String bundledUnbundledLineNumber;
	private String ohiAdjudicatedDate;
	private String adjudicated;
	private String revenueCode;
	private String procedureCode;
	private String modifier1;
	private String modifier2;
	private String modifier3;
	private String modifier4;
	private String quantity;
	private String ohiPaid;
	private String createdBy;
	private Date dateCreated;
	private Set<ClaimProcedureOhiAdjust> claimProcedureOhiAdjusts = new HashSet<ClaimProcedureOhiAdjust>(0);

	public ClaimProcedureOhi() {
	}

	public ClaimProcedureOhi(long claimProcedureOhiId, ClaimProcedure claimProcedure, String createdBy,
			Date dateCreated) {
		this.claimProcOhiId = claimProcedureOhiId;
		this.claimProcedure = claimProcedure;
		this.createdBy = createdBy;
		this.dateCreated = dateCreated;
	}

	public ClaimProcedureOhi(long claimProcedureOhiId, ClaimProcedure claimProcedure, String bundledUnbundledLineNumber,
			String ohiAdjudicatedDate, String adjudicated, String revenueCode, String procedureCode, String modifier1,
			String modifier2, String modifier3, String modifier4, String quantity, String ohiPaid, String createdBy,
			Date dateCreated, Set<ClaimProcedureOhiAdjust> claimProcedureOhiAdjusts) {
		this.claimProcOhiId = claimProcedureOhiId;
		this.claimProcedure = claimProcedure;
		this.bundledUnbundledLineNumber = bundledUnbundledLineNumber;
		this.ohiAdjudicatedDate = ohiAdjudicatedDate;
		this.adjudicated = adjudicated;
		this.revenueCode = revenueCode;
		this.procedureCode = procedureCode;
		this.modifier1 = modifier1;
		this.modifier2 = modifier2;
		this.modifier3 = modifier3;
		this.modifier4 = modifier4;
		this.quantity = quantity;
		this.ohiPaid = ohiPaid;
		this.createdBy = createdBy;
		this.dateCreated = dateCreated;
		this.claimProcedureOhiAdjusts = claimProcedureOhiAdjusts;
	}

	@Id
	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "f_seq")
	@SequenceGenerator(name = "f_seq", sequenceName = "FPPS_OWNER.MIG")
	@Column(name = "CLAIM_PROC_OHI_ID", unique = true, nullable = false, precision = 15, scale = 0)
	public long getClaimProcedureOhiId() {
		return claimProcOhiId;
	}

	public void setClaimProcedureOhiId(long claimProcedureOhiId) {
		this.claimProcOhiId = claimProcedureOhiId;
	}

	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "CLAIM_PROC_ID", nullable = false)
	public ClaimProcedure getClaimProcedure() {
		return claimProcedure;
	}

	public void setClaimProcedure(ClaimProcedure claimProcedure) {
		this.claimProcedure = claimProcedure;
	}

	@Column(name = "BUNDLED_UNBUNDLED_LINE_NUMBER", length = 20)
	public String getBundledUnbundledLineNumber() {
		return bundledUnbundledLineNumber;
	}

	public void setBundledUnbundledLineNumber(String bundledUnbundledLineNumber) {
		this.bundledUnbundledLineNumber = bundledUnbundledLineNumber;
	}

	@Column(name = "OHI_ADJUDICATED_DATE", length = 10)
	public String getOhiAdjudicatedDate() {
		return ohiAdjudicatedDate;
	}

	public void setOhiAdjudicatedDate(String ohiAdjudicatedDate) {
		this.ohiAdjudicatedDate = ohiAdjudicatedDate;
	}

	@Column(name = "ADJUDICATED", length = 4)
	public String getAdjudicated() {
		return adjudicated;
	}

	public void setAdjudicated(String adjudicated) {
		this.adjudicated = adjudicated;
	}

	@Column(name = "REVENUE_CODE", length = 4)
	public String getRevenueCode() {
		return revenueCode;
	}

	public void setRevenueCode(String revenueCode) {
		this.revenueCode = revenueCode;
	}

	@Column(name = "PROCEDURE_CODE", length = 5)
	public String getProcedureCode() {
		return procedureCode;
	}

	public void setProcedureCode(String procedureCode) {
		this.procedureCode = procedureCode;
	}

	@Column(name = "MODIFIER1", length = 2)
	public String getModifier1() {
		return modifier1;
	}

	public void setModifier1(String modifier1) {
		this.modifier1 = modifier1;
	}

	@Column(name = "MODIFIER2", length = 2)
	public String getModifier2() {
		return modifier2;
	}

	public void setModifier2(String modifier2) {
		this.modifier2 = modifier2;
	}

	@Column(name = "MODIFIER3", length = 2)
	public String getModifier3() {
		return modifier3;
	}

	public void setModifier3(String modifier3) {
		this.modifier3 = modifier3;
	}

	@Column(name = "MODIFIER4", length = 2)
	public String getModifier4() {
		return modifier4;
	}

	public void setModifier4(String modifier4) {
		this.modifier4 = modifier4;
	}

	@Column(name = "QUANTITY", length = 15)
	public String getQuantity() {
		return quantity;
	}

	public void setQuantity(String quantity) {
		this.quantity = quantity;
	}

	@Column(name = "OHI_PAID", length = 18)
	public String getOhiPaid() {
		return ohiPaid;
	}

	public void setOhiPaid(String ohiPaid) {
		this.ohiPaid = ohiPaid;
	}

	@Column(name = "CREATED_BY", nullable = false, length = 30)
	public String getCreatedBy() {
		return createdBy;
	}

	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "DATE_CREATED", nullable = false, length = 7)
	public Date getDateCreated() {
		return dateCreated;
	}

	public void setDateCreated(Date dateCreated) {
		this.dateCreated = dateCreated;
	}

	@OneToMany(fetch = FetchType.LAZY, mappedBy = "claimProcedureOhi", cascade = CascadeType.ALL)
	public Set<ClaimProcedureOhiAdjust> getClaimProcedureOhiAdjusts() {
		return claimProcedureOhiAdjusts;
	}

	public void setClaimProcedureOhiAdjusts(Set<ClaimProcedureOhiAdjust> claimProcedureOhiAdjusts) {
		this.claimProcedureOhiAdjusts = claimProcedureOhiAdjusts;
	}

}