package gov.va.med.domain.ewv;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@SuppressWarnings("serial")
@Entity(name = "ewClaimsAttachment")
@Table(name = "EWV_CLAIMS_ATTACHMENT", schema = "EWV")
public class EwvClaimAttachment implements java.io.Serializable {
	
	private long attachmentId;
	private String ediClaimKey;
	private String medicalRecordNumber;
	private String reportTypeCd;
	private String reportTypeDescription;
	private String traceNumber;
	
	public EwvClaimAttachment () {}
	
	public EwvClaimAttachment (long attachmentId, String ediClaimKey, String medicalRecordNumber, String reportTypeCd, String reportTypeDescription, String traceNumber) {
		this.attachmentId = attachmentId;
		this.ediClaimKey = ediClaimKey;
		this.medicalRecordNumber = medicalRecordNumber;
		this.reportTypeCd = reportTypeCd;
		this.reportTypeDescription = reportTypeDescription;
		this.traceNumber = traceNumber;
	}

	@Id
	
	@Column(name = "ATTACHMENT_ID", unique=true, nullable = false, precision = 10, scale = 0)
	public long getAttachmentId() {
		return attachmentId;
	}

	public void setAttachmentId(long attachmentId) {
		this.attachmentId = attachmentId;
	}

	@Column(name = "EDI_CLAIM_KEY", length = 40)
	public String getEdiClaimKey() {
		return ediClaimKey;
	}

	public void setEdiClaimKey(String ediClaimKey) {
		this.ediClaimKey = ediClaimKey;
	}

	@Column(name = "MEDICAL_RECORD_NUMBER", length = 60)
	public String getMedicalRecordNumber() {
		return medicalRecordNumber;
	}

	public void setMedicalRecordNumber(String medicalRecordNumber) {
		this.medicalRecordNumber = medicalRecordNumber;
	}

	@Column(name = "REPORT_TYPE_CD", unique = true, nullable = false, length = 20)
	public String getReportTypeCd() {
		return reportTypeCd;
	}

	public void setReportTypeCd(String reportTypeCd) {
		this.reportTypeCd = reportTypeCd;
	}

	@Column(name = "REPORT_TYPE_DESC", nullable = false, length = 90)
	public String getReportTypeDescription() {
		return reportTypeDescription;
	}

	public void setReportTypeDescription(String reportTypeDescription) {
		this.reportTypeDescription = reportTypeDescription;
	}

	@Column(name = "TRACE_NUMBER", nullable = false, length = 60)
	public String getTraceNumber() {
		return traceNumber;
	}

	public void setTraceNumber(String traceNumber) {
		this.traceNumber = traceNumber;
	}
}