package gov.va.med.domain.ars;

import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import java.util.Date;

@SuppressWarnings("serial")
@Entity(name = "aemailTemplate")
@Table(name = "EMAIL_TEMPLATES", schema = "ARS277_REQUEST_TRACKING")
public class EmailTemplate implements java.io.Serializable {
	
	private long emailTemplateId;
	private String emailTemplateHeader;
	private String emailTemplateBody;
	private String emailTemplateType;
	private Date dateModified;
	private String modifiedBy;
	
	public EmailTemplate() {}
	
	public EmailTemplate(long emailTemplateId, String emailTemplateHeader, String emailTemplateBody,
			             String emailTemplateType, Date dateModified, String modifiedBy) {
		this.emailTemplateId = emailTemplateId;
		this.emailTemplateHeader = emailTemplateHeader;
		this.emailTemplateBody = emailTemplateBody;
		this.dateModified = dateModified;
		this.modifiedBy = modifiedBy;
	}

	@Id
	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "email_template_id_seq_gen")
	@SequenceGenerator(name = "email_template_id_seq_gen", sequenceName = "EMAIL_TEMPLATE_ID_SEQ", allocationSize = 1)
	@Column(name = "EMAIL_TEMPLATE_ID", unique = true, nullable = false, precision = 22, scale = 0)
	public long getEmailTemplateId() {
		return emailTemplateId;
	}

	public void setEmailTemplateId(long emailTemplateId) {
		this.emailTemplateId = emailTemplateId;
	}

	@Column(name = "EMAIL_TEMPLATE_HEADER", length = 250)
	public String getEmailTemplateHeader() {
		return emailTemplateHeader;
	}

	public void setEmailTemplateHeader(String emailTemplateHeader) {
		this.emailTemplateHeader = emailTemplateHeader;
	}

	@Column(name = "EMAIL_TEMPLATE_BODY", length = 250)
	public String getEmailTemplateBody() {
		return emailTemplateBody;
	}

	public void setEmailTemplateBody(String emailTemplateBody) {
		this.emailTemplateBody = emailTemplateBody;
	}

	@Column(name = "EMAIL_TEMPLATE_TYPE", length = 250)
	public String getEmailTemplateType() {
		return emailTemplateType;
	}

	public void setEmailTemplateType(String emailTemplateType) {
		this.emailTemplateType = emailTemplateType;
	}

	@Temporal(TemporalType.DATE)
	@Column(name = "DATEMODIFIED", length = 7)
	public Date getDateModified() {
		return dateModified;
	}

	public void setDateModified(Date dateModified) {
		this.dateModified = dateModified;
	}

	@Column(name = "MODIFIEDBY", length = 250)
	public String getModifiedBy() {
		return modifiedBy;
	}

	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}
}
