import { Injectable } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import { Response, Http } from '@angular/http';
import 'rxjs/add/operator/map';
import { environment } from '../../environments/environment';
import { UserRequestModel, PaginationModel } from './user-admin.model';

@Injectable()
export class UserAdminService {
  constructor(private http: Http) {}
  getUserInfo(userName: string) {
    userName = encodeURIComponent(userName);
    return this.http
      .get(`${environment.nodeserver}/userDetails/userInfo/${userName}`)
      .map((data: Response) => data.json());
  }
  getAllUsers(body: PaginationModel) {
    return this.http
      .post(`${environment.nodeserver}/userDetails/userInfo`, body)
      .map((data: Response) => data.json());
  }
  deleteUserInfo(userId: string) {
    return this.http
      .get(`${environment.nodeserver}/userDetails/deleteUserInfo/${userId}`)
      .map((data: Response) => data.json());
  }
  createUser(body: UserRequestModel) {
    return this.http
      .post(`${environment.nodeserver}/userDetails/createUser`, body)
      .map((data: Response) => data.json());
  }
  modifyUser(body: UserRequestModel) {
    return this.http
      .post(`${environment.nodeserver}/userDetails/editUser`, body)
      .map((data: Response) => data.json());
  }
}
