import { FormBuilder, Validators, FormGroup } from '@angular/forms';
import { Component, OnInit, OnDestroy } from '@angular/core';
import { Subscription } from 'rxjs/Subscription';

import {
  UserRequestModel,
  UserModel,
  SearchModel,
  PaginationModel
} from './user-admin.model';
import { UserAdminService } from './user-admin.service';
import {
  TableColumnModel,
  TableSettings,
  PaginationSettings
} from './../shared/table/table.component.model';
@Component({
  selector: 'app-user-admin',
  templateUrl: './user-admin.component.html',
  styleUrls: ['./user-admin.component.scss'],
  providers: [UserAdminService]
})
export class UserAdminComponent implements OnInit, OnDestroy {
  constructor(
    private fb: FormBuilder,
    private userAdminService: UserAdminService
  ) {}
  deleteEvent;
  errorStatus = false;
  errorMsg = '';
  modalClosed = true;
  deleteModalClosed = true;
  showResults = false;
  searchUserClicked = false;
  createForm: FormGroup;
  searchForm: FormGroup;
  modifyForm: FormGroup;
  requestModel: UserRequestModel = new UserRequestModel();
  editRequestModel: UserRequestModel = new UserRequestModel();
  paginationModel: PaginationModel = new PaginationModel();
  searchModel: SearchModel = new SearchModel();
  searchResults: UserModel[] = [];
  loading = true;
  modalError = false;
  successMsg = '';
  successStatus = false;
  // includeInactive = false;
  subscription: Subscription = new Subscription();
  // allUserSubscription: Subscription;
  // searchUserSubscription: Subscription;
  // deleteSubscription: Subscription;
  // createSubscription: Subscription;
  // modifySubscription: Subscription;
  enableEdit = false;
  enableExport = false;
  isAdmin = false;
  status = true;

  modifyEnableEdit = false;
  modifyEnableExport = false;
  modifyIsAdmin = false;
  modifyStatus = true;
  userValueBeforeChange: UserRequestModel;
  tableColumns: TableColumnModel[] = [
    new TableColumnModel('UserName', 'userName'),
    new TableColumnModel('Domain ', 'domain'),
    new TableColumnModel('Last Name', 'lastName'),
    new TableColumnModel('First Name', 'firstName'),
    new TableColumnModel('Phone Number', 'phone'),
    new TableColumnModel('Email', 'email'),
    new TableColumnModel('Status', 'status'),
    new TableColumnModel('Export', 'export'),
    new TableColumnModel('Edit', 'edit'),
    new TableColumnModel('Admin', 'admin')
  ];
  tableSettings: TableSettings = new TableSettings();
  paginationSettings: PaginationSettings = new PaginationSettings();
  ngOnInit() {
    this.tableSettings.buttonShow = true;
    this.tableSettings.buttonNames = ['Modify'];
    this.formInit();
  }
  formInit() {
    this.createForm = this.fb.group({
      userName: [
        this.requestModel.userName,
        [Validators.required, Validators.pattern('[0-9A-Za-z]*')]
      ],
      domain: this.requestModel.domain,
      export: this.enableExport,
      edit: this.enableEdit,
      admin: this.isAdmin,
      phone: [this.requestModel.phone, Validators.pattern('[0-9]*')],
      email: [
        this.requestModel.email,
        [
          Validators.required,
          Validators.pattern(
            '[a-zA-Z0-9._%+-]{1,}@[a-zA-Z.-]{2,}[.]{1}[a-zA-Z]{2,}'
          )
        ]
      ],
      firstName: this.requestModel.firstName,
      lastName: this.requestModel.lastName,
      status: this.status
    });
    this.searchForm = this.fb.group({
      userName: [
        this.searchModel.userName,
        [Validators.required, Validators.pattern('[a-zA-Z0-9]*')]
      ],
      includeInactive: this.paginationModel.inActiveUsers
    });
    this.modifyForm = this.fb.group({
      // editUserName: [this.editRequestModel.userName, Validators.required],
      editDomain: this.editRequestModel.domain,
      editExport: this.modifyEnableExport,
      editEdit: this.modifyEnableEdit,
      editAdmin: this.modifyIsAdmin,
      editPhone: [this.editRequestModel.phone, Validators.pattern('[0-9]*')],
      editEmail: [
        this.editRequestModel.email,
        Validators.pattern(
          '[a-zA-Z0-9._%+-]{1,}@[a-zA-Z.-]{2,}[.]{1}[a-zA-Z]{2,}'
        )
      ],
      editFirstName: this.editRequestModel.firstName,
      editLastName: this.editRequestModel.lastName,
      editStatus: this.modifyStatus
    });
  }
  search() {
    this.searchUserClicked = true;
    this.paginationSettings = new PaginationSettings();
    this.fetchData();
  }
  fetchData() {
    this.loading = true;
    this.errorMsg = '';
    this.errorStatus = false;
    if (this.searchUserClicked) {
      const searchUserSubscription = this.userAdminService
        .getUserInfo(this.searchModel.userName.trim())
        .subscribe(data => {
          if (data.errorCode) {
            this.errorMsg = 'Error Occured';
            this.errorStatus = true;
            this.successMsg = '';
            this.successStatus = false;
            this.showResults = false;
          } else {
            this.showResults = true;
            this.searchResults = [];
            this.searchResults = data.response;
            this.tableSettings.pagination = false;
            this.errorMsg = '';
            this.successMsg = '';
            this.successStatus = false;
            this.errorStatus = false;
            this.loading = false;
          }
        });
      this.subscription.add(searchUserSubscription);
    } else {
      this.paginationModel.pageSize = this.paginationSettings.pageSize;
      this.paginationModel.pageNumber = this.paginationSettings.currentPage;
      this.paginationModel.descending = this.paginationSettings.descending;
      this.paginationModel.sortColumn = this.paginationSettings.sortColumn;
      const allUserSubscription = this.userAdminService
        .getAllUsers(this.paginationModel)
        .subscribe(data => {
          if (data.errorCode) {
            this.paginationSettings = new PaginationSettings();
            this.errorMsg = 'Error Occured';
            this.errorStatus = true;
            this.successMsg = '';
            this.successStatus = false;
            this.showResults = false;
          } else {
            this.showResults = true;
            this.tableSettings.pagination = true;
            this.searchResults = data.response;
            this.errorMsg = '';
            this.errorStatus = false;
            this.loading = false;
            this.paginationSettings = {
              currentPage: data.pageNumber,
              pageSize: data.pageSize,
              totalPages: Math.ceil(data.totalNumberOfResults / data.pageSize),
              totalResults: data.totalNumberOfResults,
              sortColumn: data.sortColumn,
              descending: this.paginationModel.descending
            };
          }
        });
      this.subscription.add(allUserSubscription);
    }
  }
  updateTable() {
    this.fetchData();
  }
  listAllUsers() {
    this.searchUserClicked = false;
    this.paginationSettings = new PaginationSettings();
    this.fetchData();
  }
  resetSearchForm() {
    this.showResults = false;
    this.searchUserClicked = false;
    this.formInit();
    this.clearMsgs();
    this.searchModel = new SearchModel();
    this.paginationModel = new PaginationModel();
  }
  clearMsgs() {
    this.errorMsg = '';
    this.errorStatus = false;
    this.successMsg = '';
    this.successStatus = false;
  }
  resetCreateForm() {
    this.clearMsgs();
    this.formInit();
    this.enableEdit = false;
    this.enableExport = false;
    this.isAdmin = false;
    this.status = true;
    this.requestModel = new UserRequestModel();
  }

  buttonClicked(event) {
    // if (event.buttonName === 'Modify') {
    this.openEditModal(event);
    // }
    // else {
    //   this.openDeleteModal(event);
    //   // this.delete(event);
    // }
  }
  // openDeleteModal(event) {
  //   this.deleteModalClosed = false;
  //   this.deleteEvent = { ...event };
  // }
  openEditModal(event) {
    this.editRequestModel = { ...event.row };

    this.userValueBeforeChange = { ...event.row };
    this.modalClosed = false;

    this.editRequestModel.edit === 'Yes'
      ? (this.modifyEnableEdit = true)
      : (this.modifyEnableEdit = false);
    this.editRequestModel.status === 'Active'
      ? (this.modifyStatus = true)
      : (this.modifyStatus = false);
    this.editRequestModel.admin === 'Yes'
      ? (this.modifyIsAdmin = true)
      : (this.modifyIsAdmin = false);
    this.editRequestModel.export === 'Yes'
      ? (this.modifyEnableExport = true)
      : (this.modifyEnableExport = false);
  }
  // delete() {
  //   const deleteSubscription = this.userAdminService
  //     .deleteUserInfo(this.deleteEvent.row.userId)
  //     .subscribe(data => {
  //       if (data.errorCode) {
  //         this.errorMsg = 'An error occurred during user deletion.';
  //         this.errorStatus = true;
  //         this.successStatus = false;
  //         this.successMsg = '';
  //         this.showResults = false;
  //       } else {
  //         if (this.searchUserClicked) {
  //           this.showResults = false;
  //         } else {
  //           this.successMsg = 'User was successfully deleted.';
  //           this.successStatus = true;
  //           this.errorMsg = '';
  //           this.errorStatus = false;
  //           this.showResults = true;
  //           this.listAllUsers();
  //           this.onDeleteModalClose();
  //         }
  //       }
  //     });
  //   this.subscription.add(deleteSubscription);
  // }
  createUser() {
    this.enableExport
      ? (this.requestModel.export = 'Y')
      : (this.requestModel.export = 'N');
    this.enableEdit
      ? (this.requestModel.edit = 'Y')
      : (this.requestModel.edit = 'N');
    this.status
      ? (this.requestModel.status = 'Y')
      : (this.requestModel.status = 'N');
    this.isAdmin
      ? (this.requestModel.admin = 'Y')
      : (this.requestModel.admin = 'N');
    this.requestModel.createdBy = sessionStorage.getItem('userName');
    const createSubscription = this.userAdminService
      .createUser(this.requestModel)
      .subscribe(data => {
        if (data.errorCode) {
          // this.errorMsg = 'An error occurred during user creation.';
          this.errorMsg = data.message;
          this.errorStatus = true;
          this.successMsg = '';
          this.successStatus = false;
        } else {
          this.successMsg = 'User was successfully created.';
          this.successStatus = true;
          this.errorMsg = '';
          this.errorStatus = false;
        }
      });
    this.subscription.add(createSubscription);
  }
  modifyUser() {
    this.modalClosed = true;
    this.modifyEnableExport
      ? (this.editRequestModel.export = 'Y')
      : (this.editRequestModel.export = 'N');
    this.modifyEnableEdit
      ? (this.editRequestModel.edit = 'Y')
      : (this.editRequestModel.edit = 'N');
    this.modifyStatus
      ? (this.editRequestModel.status = 'Y')
      : (this.editRequestModel.status = 'N');
    this.modifyIsAdmin
      ? (this.editRequestModel.admin = 'Y')
      : (this.editRequestModel.admin = 'N');
    this.editRequestModel.modifiedBy = sessionStorage.getItem('userName');
    const modifySubscription = this.userAdminService
      .modifyUser(this.editRequestModel)
      .subscribe(data => {
        if (data.errorCode) {
          this.errorMsg = 'An error occurred during user modification.';
          this.errorStatus = true;
          this.successMsg = '';
          this.successStatus = false;
        } else {
          this.successMsg = 'User was successfully modified.';
          this.successStatus = true;
          this.errorMsg = '';
          this.errorStatus = false;
          this.listAllUsers();
        }
      });
    this.subscription.add(modifySubscription);
  }
  onModalClose(event) {
    this.modalClosed = true;
  }

  // onDeleteModalClose() {
  //   this.deleteModalClosed = true;
  //   this.deleteEvent = null;
  // }

  resetModal() {
    this.editRequestModel = { ...this.userValueBeforeChange };
    this.modalClosed = true;
  }
  ngOnDestroy() {
    this.subscription.unsubscribe();
  }
}
