import { UserAdminComponent } from './user-admin.component';
import { FormBuilder } from '@angular/forms';
import { UserAdminService } from './user-admin.service';
import { PaginationSettings } from '../shared/table/table.component.model';
import { Observable } from 'rxjs/Observable';
import {
  UserModel,
  PaginationModel,
  UserRequestModel
} from './user-admin.model';

describe('UserAdminComponent', () => {
  let fb: FormBuilder;
  let userAdminService: UserAdminService;
  let component: UserAdminComponent;

  beforeEach(() => {
    fb = new FormBuilder();
    userAdminService = new UserAdminService(null);
    component = new UserAdminComponent(fb, userAdminService);
  });

  it('should be created', () => {
    expect(component).toBeTruthy();
  });

  it('should test ngOnInit', () => {
    const formInitSpy = spyOn(component, 'formInit');
    component.tableSettings.buttonShow = false;
    component.ngOnInit();
    expect(formInitSpy).toHaveBeenCalled();
    expect(component.tableSettings.buttonShow).toBeTruthy();
    expect(component.tableSettings.buttonNames).toEqual(['Modify']);
  });

  it('should test formInit', () => {
    component.formInit();

    component.createForm.get('userName').setValue('hi');
    expect(component.createForm.get('userName').valid).toBeTruthy();

    component.createForm.get('userName').setValue('');
    expect(component.createForm.get('userName').valid).toBeFalsy();

    // ***********************************************************************

    component.createForm.get('phone').setValue('123');
    expect(component.createForm.get('phone').valid).toBeTruthy();

    component.createForm.get('phone').setValue('abc');
    expect(component.createForm.get('phone').valid).toBeFalsy();

    // next form
    // ***********************************************************************
    // ***********************************************************************

    component.searchForm.get('userName').setValue('hi');
    expect(component.searchForm.get('userName').valid).toBeTruthy();

    component.searchForm.get('userName').setValue('');
    expect(component.searchForm.get('userName').valid).toBeFalsy();

    // next form
    // ***********************************************************************
    // ***********************************************************************

    // component.modifyForm.get('editUserName').setValue('hi');
    // expect(component.modifyForm.get('editUserName').valid).toBeTruthy();

    // component.modifyForm.get('editUserName').setValue('');
    // expect(component.modifyForm.get('editUserName').valid).toBeFalsy();

    // ***********************************************************************

    component.modifyForm.get('editPhone').setValue('123');
    expect(component.modifyForm.get('editPhone').valid).toBeTruthy();

    component.modifyForm.get('editPhone').setValue('abc');
    expect(component.modifyForm.get('editPhone').valid).toBeFalsy();

    expect(component.createForm).toBeTruthy();
    expect(component.searchForm).toBeTruthy();
    expect(component.modifyForm).toBeTruthy();
  });

  it('should test search method', () => {
    component.searchUserClicked = false;
    component.paginationSettings = new PaginationSettings();
    component.paginationSettings.sortColumn = 'sort';
    const fetchDataSpy = spyOn(component, 'fetchData');

    component.search();

    expect(component.searchUserClicked).toBeTruthy();
    expect(component.paginationSettings.sortColumn).toEqual('');
    expect(fetchDataSpy).toHaveBeenCalled();
  });

  it('should test fetchData method with error', () => {
    component.searchUserClicked = true;

    const getUserInfoSpy = spyOn(userAdminService, 'getUserInfo').and.callFake(
      () => new Observable(observer => observer.next({ errorCode: true }))
    );
    component.fetchData();

    expect(component.errorMsg).toEqual('Error Occured');
  });

  it('should test fetchData method without error and searchUserClicked true', () => {
    component.searchUserClicked = true;

    const getUserInfoSpy = spyOn(userAdminService, 'getUserInfo').and.callFake(
      () => new Observable(observer => observer.next({ errorCode: false }))
    );
    component.fetchData();

    expect(component.showResults).toBeTruthy();
  });

  it('should test fetchData method with searchUserClicked false and an error', () => {
    component.searchUserClicked = false;

    const getUserInfoSpy = spyOn(userAdminService, 'getAllUsers').and.callFake(
      () => new Observable(observer => observer.next({ errorCode: true }))
    );
    component.fetchData();

    expect(component.errorMsg).toEqual('Error Occured');
  });

  it('should test fetchData method with searchUserClicked false and no error', () => {
    component.searchUserClicked = false;

    const getUserInfoSpy = spyOn(userAdminService, 'getAllUsers').and.callFake(
      () => new Observable(observer => observer.next({ errorCode: false }))
    );

    component.fetchData();

    expect(component.errorMsg).toEqual('');
    expect(component.showResults).toBeTruthy();
  });

  it('should test updateTable method', () => {
    const updateTableSpy = spyOn(component, 'fetchData');
    component.updateTable();

    expect(updateTableSpy).toHaveBeenCalled();
  });

  it('should test listAllUsers method', () => {
    component.searchUserClicked = true;
    const fetchDataSpy = spyOn(component, 'fetchData');

    component.listAllUsers();

    expect(component.searchUserClicked).toBeFalsy();
    expect(component.paginationSettings).toEqual(new PaginationSettings());
    expect(fetchDataSpy).toHaveBeenCalled();
  });

  it('should test resetSearchForm method', () => {
    component.showResults = true;
    const clearMsgsSpy = spyOn(component, 'clearMsgs');

    component.resetSearchForm();

    expect(component.showResults).toBeFalsy();
    expect(component.paginationModel).toEqual(new PaginationModel());
    expect(clearMsgsSpy).toHaveBeenCalled();
  });

  it('should test clearMsgs method', () => {
    component.errorStatus = true;
    component.clearMsgs();

    expect(component.errorStatus).toBeFalsy();
  });

  it('should test resetCreateForm method', () => {
    const clearMsgsSpy = spyOn(component, 'clearMsgs');
    component.requestModel = new UserRequestModel();
    component.requestModel.edit = 'something';
    component.enableEdit = true;
    component.resetCreateForm();

    expect(component.enableEdit).toBeFalsy();
    expect(clearMsgsSpy).toHaveBeenCalled();
    expect(component.requestModel).toEqual(new UserRequestModel());
  });

  it('should test buttonClicked method with buttonName set to Modify', () => {
    const openEditModalSpy = spyOn(component, 'openEditModal');

    component.buttonClicked({ buttonName: 'Modify' });

    expect(openEditModalSpy).toHaveBeenCalled();
  });
  // this test needs to be re-written due to change on buttonClicked.
  // it('should test buttonClicked method without buttonName Edit', () => {
  //   const deleteSpy = spyOn(component, 'delete');

  //   component.buttonClicked({buttonName: false});

  //   expect(deleteSpy).toHaveBeenCalled();
  // });

  it('should test openEditModal method', () => {
    component.modalClosed = true;
    component.openEditModal({ row: { thing: 'thing' } });

    expect(component.modalClosed).toBeFalsy();
    expect(component.editRequestModel['thing']).toEqual('thing');
  });

  it('should test openEditModal method', () => {
    component.modalClosed = true;
    component.openEditModal({ row: { thing: 'thing' } });

    expect(component.modalClosed).toBeFalsy();
    expect(component.editRequestModel['thing']).toEqual('thing');
  });

  // it('should test delete method with error', () => {
  //   const deleteUserInfoSpy = spyOn(userAdminService, 'deleteUserInfo').and.callFake(
  //     () => new Observable((observer) => observer.next({errorCode: true}))
  //   );
  //   component.delete({row: {userId: 1}});

  //   expect(component.errorStatus).toBeTruthy();
  // });

  // it('should test delete method without error', () => {
  //   component.searchUserClicked = false;
  //   const deleteUserInfoSpy = spyOn(userAdminService, 'deleteUserInfo').and.callFake(
  //     () => new Observable((observer) => observer.next({errorCode: false}))
  //   );
  //   const listAllUsersSpy = spyOn(component, 'listAllUsers');
  //   component.delete({row: {userId: 1}});

  //   expect(component.successMsg).toEqual('Deleted Successfully');
  //   expect(deleteUserInfoSpy).toHaveBeenCalled();
  // });

  it('should test createUser method with error', () => {
    component.enableExport = true;
    component.enableEdit = true;
    component.isAdmin = true;
    sessionStorage.setItem('userName', '{"name": "Joseph"}');

    const createUserSpy = spyOn(userAdminService, 'createUser').and.callFake(
      () =>
        new Observable(observer =>
          observer.next({ errorCode: true, message: 'message' })
        )
    );

    component.createUser();

    expect(component.requestModel.export).toEqual('Y');
    expect(component.requestModel.edit).toEqual('Y');
    expect(component.requestModel.admin).toEqual('Y');
    expect(component.requestModel.createdBy).toEqual('{"name": "Joseph"}');
    expect(component.errorMsg).toBeTruthy();
  });

  it('should test createUser method without error', () => {
    component.enableExport = true;
    component.enableEdit = true;
    component.isAdmin = true;
    sessionStorage.setItem('userName', '{"name": "Joseph"}');

    const createUserSpy = spyOn(userAdminService, 'createUser').and.callFake(
      () => new Observable(observer => observer.next({ errorCode: false }))
    );

    component.createUser();

    expect(component.requestModel.export).toEqual('Y');
    expect(component.requestModel.edit).toEqual('Y');
    expect(component.requestModel.admin).toEqual('Y');
    expect(component.requestModel.createdBy).toEqual('{"name": "Joseph"}');
    expect(component.successMsg).toEqual('User was successfully created.');
  });

  it('should test modifyUser method with error', () => {
    component.enableExport = true;
    component.enableEdit = true;
    component.isAdmin = true;
    sessionStorage.setItem('userName', '{"name": "Joseph"}');

    const modifyUserSpy = spyOn(userAdminService, 'modifyUser').and.callFake(
      () => new Observable(observer => observer.next({ errorCode: true }))
    );

    component.modifyUser();

    expect(component.errorMsg).toEqual(
      'An error occurred during user modification.'
    );
  });

  it('should test modifyUser method without error', () => {
    component.enableExport = true;
    component.enableEdit = true;
    component.isAdmin = true;
    sessionStorage.setItem('userName', '{"name": "Joseph"}');

    const modifyUserSpy = spyOn(userAdminService, 'modifyUser').and.callFake(
      () => new Observable(observer => observer.next({ errorCode: false }))
    );
    const listAllUsersSpy = spyOn(component, 'listAllUsers');

    component.modifyUser();

    expect(component.successMsg).toEqual('User was successfully modified.');
    expect(listAllUsersSpy).toHaveBeenCalled();
  });
});
