import {
  Component,
  OnInit,
  Input,
  EventEmitter,
  Output,
  SimpleChange,
  ViewChild,
  ElementRef
} from '@angular/core';
import { TableService } from './table.service';
import {
  TableColumnModel,
  PaginationSettings,
  TableSettings
} from './table.component.model';

@Component({
  selector: 'app-table',
  templateUrl: './table.component.html',
  styleUrls: ['./table.component.scss']
})
export class TableComponent implements OnInit {
  @Input() tabable = false;
  @Input() paginationSettings: PaginationSettings;
  @Input() tableSettings: TableSettings;
  @Input() columns: TableColumnModel[];
  @Input() rows: any[] = [];
  @Input() loading = true;
  @Input() imgProperty: string = null;
  @Output() notify = new EventEmitter();
  @Output() linkNotify = new EventEmitter();
  @Output() imgNotify = new EventEmitter();
  @Output() buttonNotify = new EventEmitter();
  @Output() sortNotify = new EventEmitter();
  @ViewChild('rowVal') rowVal: ElementRef;

  // pagination settings
  pageSizes = [10, 25, 50, 100];
  currentPage = 1;
  // end of pagination settings
  selectAll = false;
  metaData: TableColumnModel[];
  data;
  @ViewChild('noRows') noRows: ElementRef = new ElementRef('');
  constructor(private service: TableService) {}

  ngOnInit() {}
  linkButton(value) {
    this.linkNotify.emit(value);
  }
  buttonClicked(row, buttonName) {
    this.buttonNotify.emit({ row, buttonName });
    // console.log('row ', row);
  }
  imgClicked(row, imgIndex) {
    this.imgNotify.emit({ data: row, imgIndex });
  }
  isValANumber(val) {
    const reg = /\d{2}\/\d{2}\/\d{4}/;
    if (!isNaN(+val) || reg.test(val)) {
      return true;
    } else {
      return false;
    }
  }
  selectItems(bool) {
    this.selectAll = bool;
    this.rows.forEach(val => (val.row_selected = bool));
    return this.selectAll;
  }
  // icomImages is a method specific for the attachmentViewerComponent.
  iconImages(index): string {
    const ext = this.rows[index]['pathAddress'][0].split('.').pop().toUpperCase();
    switch(ext) {
      case 'XML':
        return './../../../assets/images/ic_XML_icon_24.svg';
      case 'PDF':
        return './../../../assets/images/ic_PDF_icon_24.svg';
      case 'PNG':
        return './../../../assets/images/ic_PNG_icon_24.svg';
      case 'TIFF':
        return './../../../assets/images/ic_TIFF_icon_24.svg';
      case 'TIF':
        return './../../../assets/images/ic_TIFF_icon_24.svg';
      case 'TXT':
        return './../../../assets/images/ic_TXT_icon_24.svg';
      case 'DOC':
        return './../../../assets/images/ic_DOC_icon_24.svg';
      case 'DCM':
        return './../../../assets/images/ic_DCM_icon_24.svg';
      case 'JPG':
        return './../../../assets/images/ic_JPG_icon_24.svg';
      case 'GIF':
        return './../../../assets/images/ic_GIF_icon_24.svg';
      case 'RTF':
        return './../../../assets/images/ic_RTF_icon_24.svg';
      case 'HTML':
        return './../../../assets/images/ic_HTML_icon_24.svg';
      case 'BMP':
        return './../../../assets/images/ic_BMP_icon_24.svg';
      default:
        return './../../../assets/images/ic_attachCount_blue_24.svg';
    }
  }
  sortTable(column) {
    this.paginationSettings.sortColumn = column;
    this.paginationSettings.descending = !this.paginationSettings.descending;
    console.log('tableComponent pagination settings ', this.paginationSettings);
    this.notify.emit();
    // this.sortNotify.emit();
  }
}
