import {
  Component,
  OnInit,
  Input,
  Output,
  EventEmitter,
  OnChanges,
  SimpleChange,
  SimpleChanges
} from '@angular/core';

import { PaginationSettings } from './../table.component.model';

@Component({
  selector: 'app-pagination',
  templateUrl: './pagination.component.html',
  styleUrls: ['./pagination.component.scss']
})
export class PaginationComponent implements OnInit {
  @Input() tabable = false;
  @Input() paginationSettings: PaginationSettings;
  @Input() pages;
  @Input() dropdownValue = [10, 15, 25];
  @Output() notify = new EventEmitter();
  constructor() {}

  ngOnInit() {}
  newPageRequest(pageNumber: number) {
    this.paginationSettings.currentPage = pageNumber;
    this.notify.emit();
  }

  newPageSize(pageSize: number) {
    this.paginationSettings.pageSize = pageSize;
    this.paginationSettings.currentPage = 1;
    this.notify.emit();
  }

  updatePage(direction: string) {
    if (direction === 'left' && this.paginationSettings.currentPage !== 1) {
      this.paginationSettings.currentPage -= 1;
      this.notify.emit();
    }
    if (
      direction === 'right' &&
      this.paginationSettings.currentPage < this.paginationSettings.totalPages
    ) {
      this.paginationSettings.currentPage += 1;
      this.notify.emit();
    }
  }
}
