import { Component, OnInit, Input } from '@angular/core';

@Component({
  selector: 'app-navigation',
  templateUrl: './navigation.component.html',
  styleUrls: ['./navigation.component.scss']
})
export class NavigationComponent implements OnInit {
  userRoles;
  permissions: any;
  showAdmin = false;
  showEWV = false;
  show275 = false;
  constructor() {}
  @Input() tabable = true;
  ngOnInit() {
    this.userRoles = JSON.parse(sessionStorage.getItem('userRole'));
    this.permissions = JSON.parse(sessionStorage.getItem('permissions'));
    this.showAdmin = this.userRoles.some(data => data === 'ADMIN');
    this.showEWV = this.userRoles.some(data => data === 'EWV');
    this.show275 = this.permissions.search275.pageViewAccess;
    // console.log('show275', this.show275);
  }
}
