import {
  Component,
  OnInit,
  Input,
  Output,
  EventEmitter,
  ViewChild,
  ElementRef,
  OnChanges,
  SimpleChanges
} from '@angular/core';
import { NgForm } from '@angular/forms';

@Component({
  selector: 'app-modal',
  template: `
    <div id="modal1" class="modal-overlay" [class.modal-show]="!hidden" [style.visibility]="hidden? 'hidden': 'visible'">
        <div class="modal-content center-align">
            <a #closeBtn class="close clickable" (keydown)="$event.key === 'Enter'? onModalClose(): ''" (click)="onModalClose()" tabindex="1">&times;</a>
            <ng-content></ng-content>
        </div>
    </div>
    `,
  styleUrls: ['./modal.component.scss']
})
export class ModalComponent implements OnInit, OnChanges {
  @ViewChild('closeBtn') closeButton: ElementRef = new ElementRef('');
  @Input() header = 'formControl';
  @Input() modalTitle = null;
  @Input() hidden = true;
  @Output() modalClosed = new EventEmitter<boolean>();
  modal = 'this is the modal string';

  constructor() {}

  ngOnInit() {}
  ngOnChanges(changes: SimpleChanges) {
    if (!changes.hidden.currentValue) {
      setTimeout(() => {
        this.closeButton.nativeElement.focus();
      }, 100);
    }
  }
  onModalClose() {
    this.hidden = true;
    this.modalClosed.emit(this.hidden);
  }
}
