import { Observable } from 'rxjs/Observable';
import { ModalComponent } from './modal.component';

describe('ModalComponent', () => {
  let component: ModalComponent;

  beforeEach(() => {
    component = new ModalComponent();
  });

  it('ModalComponent should be created', () => {
    expect(component).toBeTruthy();
  });

  it('tests onModalClose', () => {
    const spyOnModalClosedEmit = spyOn(component.modalClosed, 'emit');
    component.onModalClose();

    expect(component.hidden).toBe(true);
    expect(spyOnModalClosedEmit).toHaveBeenCalledWith(component.hidden);
  });
});
