import { Directive, ElementRef, AfterViewInit, Input } from '@angular/core';
import { Element } from '@angular/compiler';

@Directive({
  selector: '[appAutofocus]'
})
export class AutofocusDirective implements AfterViewInit {
  @Input() appAutofocusDisplay = true;
  constructor(private el: ElementRef) {}
  ngAfterViewInit() {
    if (this.appAutofocusDisplay) {
      // added setTimeout to work with IE's slow loading
      setTimeout(() => this.el.nativeElement.focus(), 100);
    }
  }
}
