import { Injectable } from '@angular/core';
import { CanActivate, ActivatedRouteSnapshot, Router } from '@angular/router';
import { AuthenticationService } from './../login/login.service';

@Injectable()
export class AuthRouteActivatorService implements CanActivate {
  constructor(
    private authenticationService: AuthenticationService,
    private router: Router
  ) {}

  canActivate(route: ActivatedRouteSnapshot): boolean {
    let userRoles = JSON.parse(sessionStorage.getItem('userRole'));
    let hasAdminPermission = userRoles.some(data => data === 'ADMIN');
    let hasEwvPermission = userRoles.some(data => data === 'EWV');
    let has275Permission = userRoles.some(data => data === 'BASE_USER');

    if (route.url[0].path === 'userAdmin') {
      if (hasAdminPermission) {
        return true;
      } else {
        this.router.navigate(['login']);
      }
    }

    if (route.url[0].path === 'arsReports') {
      if (hasAdminPermission) {
        return true;
      } else {
        this.router.navigate(['login']);
      }
    }

    if (route.url[0].path === 'search275') {
      if (hasAdminPermission || has275Permission) {
        return true;
      } else {
        this.router.navigate(['login']);
      }
    }

    if (route.url[0].path === 'ewvSearch') {
      if (hasEwvPermission) {
        return true;
      } else {
        this.router.navigate(['login']);
      }
    }
  }
}
