import { ElementRef } from '@angular/core';
import { of } from 'rxjs/observable/of';
import { FormBuilder } from '@angular/forms';
import { AttachmentViewerComponent } from './attachment-viewer.component';
import { Search275Service } from './../../search275/search275.service';
import { AttachmentViewerService } from './attachment-viewer.service';

describe('AttachmentViewerComponent', () => {
  let component: AttachmentViewerComponent;
  let service: Search275Service;
  let attachmentService: AttachmentViewerService;
  const document = {
    body: {
      style: { overflow: '' },
      execCommand: command => {
        return true;
      }
    }
  };

  beforeEach(() => {
    service = new Search275Service(null);
    attachmentService = new AttachmentViewerService(null);
    component = new AttachmentViewerComponent(
      service,
      null,
      document,
      new FormBuilder(),
      attachmentService
    );
  });

  it('should be created', () => {
    expect(component).toBeTruthy();
  });
  it('should test ngOnChanges', () => {
    const spy = spyOn(component, 'ngOnChanges').and.callFake(() => {
      return true;
    });
    component.ngOnChanges(null);
    expect(spy).toHaveBeenCalled();
  });
  it('should test closeViewer method', () => {
    component.fileExtension = 'XML';
    component.formInit();
    component.form.controls['unmatched837Id'].setValue('321');
    component.closeViewer();
    expect(component.fileExtension).toBeNull();
  });
  it('should test nextAttachment method', () => {
    component.attachmentList = ['1', '2', '3'];
    component.selectedAttachment = component.attachmentList[0];
    component.nextAttachment();
    expect(component.selectedAttachment).toBe('2');
  });
  it('should test previousAttachment method', () => {
    component.attachmentList = ['1', '2', '3'];
    component.selectedAttachment = component.attachmentList[1];
    component.previousAttachment();
    expect(component.selectedAttachment).toBe('1');
  });
  it('should test setFileExtention method', () => {
    component.setfileExtension('http://www.test.com/medical_image.jpg');
    expect(component.fileExtension).toBe('JPG');
  });
  it('shoult test onXmlFile method', () => {
    const onXmlMethod = spyOn(component, 'onXmlFile').and.returnValue(
      'sanitized'
    );
    expect(component.onXmlFile()).toBe('sanitized');
  });
  it('should test viewAssociateForm method', () => {
    component.associateView = false;
    component.viewAssociateForm();
    expect(component.associateView).toBe(true);
  });
  it('should test copyToClipboard method', () => {
    const copyMethodSpy = spyOn(component, 'copyToClipboard');
    component.copyToClipboard();
    expect(copyMethodSpy).toHaveBeenCalled();
  });
  it('should test onArchiveView method', () => {
    component.modalView = false;
    component.onArchiveView();
    expect(component.modalView).toBe(true);
  });
  it('should test onModalClose method', () => {
    component.modalView = true;
    component.onModalClose();
    expect(component.modalView).toBe(false);
  });
  it('should test clipBoardMessage method', () => {
    component.tempMessage = '';
    component.showMessage = false;
    component.clipBoardMessage();
    expect(component.tempMessage).toBeTruthy();
  });
});
