import { FormBuilder } from '@angular/forms';
import { Observable } from 'rxjs/Observable';
import { from } from 'rxjs/observable/from';
import { ScriptService } from './../shared/scriptLoader/script.service';
import { Search275Service } from './search275.service';
import { Search275Component } from './search275.component';
import { ResponseModel, Search275Model } from './search275.component.model';

describe('Search275Component', () => {
  let component: Search275Component;
  let script: ScriptService;
  let searchService: Search275Service;
  let fb: FormBuilder;

  beforeEach(() => {
    fb = new FormBuilder();
    searchService = new Search275Service(null);
    script = new ScriptService();
    component = new Search275Component(fb, searchService, script);
    component.formInit();
  });
  it('should be created', () => {
    expect(component).toBeTruthy();
  });

  it('should test ngOnInit', () => {
    const formInitSpy = spyOn(component, 'formInit');
    const getUserDataSpy = spyOn(component, 'getUserData');
    const TableInitSpy = spyOn(component, 'tableInit');
    // const serviceSpy = spyOn(searchService, 'getSampleData').and.callFake(() => {
    //   return from(['1', '2', '3']);
    // });
    component.ngOnInit();
    expect(getUserDataSpy).toHaveBeenCalled();
    expect(formInitSpy).toHaveBeenCalled();
    expect(TableInitSpy).toHaveBeenCalled();
  });
  it('should create the form', () => {
    component.formInit();
    expect(component.form).toBeTruthy();
  });
  // the following tests should test validators on the form.
  it('should test validation on attachId field', () => {
    component.form.get('attachId').setValue('test');
    expect(component.form.get('attachId').valid).toBeFalsy();
  });
  it('should test validation on claimId field', () => {
    component.form.get('claimId').setValue('test');
    expect(component.form.get('claimId').valid).toBeFalsy();
  });
  it('should test validation on patientIdentifier field', () => {
    component.form.get('patientIdentifier').setValue('test');
    expect(component.form.get('patientIdentifier').valid).toBeFalsy();
  });
  it('should test validation on providerNpi field', () => {
    component.form.get('providerNpi').setValue('test');
    expect(component.form.get('providerNpi').valid).toBeFalsy();
  });
  it('should test validation on medicalRecordNumber field', () => {
    component.form.get('medicalRecordNumber').setValue('test');
    expect(component.form.get('medicalRecordNumber').valid).toBeFalsy();
  });
  it('should test validation on claimServiceStartDate field', () => {
    component.form.get('claimServiceStartDate').setValue('test');
    expect(component.form.get('claimServiceStartDate').valid).toBeFalsy();
  });
  it('should test validation on claimServiceEndDate field', () => {
    component.form.get('claimServiceEndDate').setValue('test');
    expect(component.form.get('claimServiceEndDate').valid).toBeFalsy();
  });
  // end of form tests.
  it('should test tableInit method', () => {
    component.tableInit();
    expect(component.tableSettings.imgColumn).toEqual(true);
  });

  it('should test resetForm method', () => {
    component.serviceStartDate = { nativeElement: { value: '01/20/2010' } };
    component.serviceEndDate = { nativeElement: { value: '01/20/2017' } };
    component.requestModel.claimId = '10000';
    component.errorStatus = true;
    component.errorMsg = 'error';
    component.resetForm();
    expect(component.requestModel.claimId).toBeFalsy();
    expect(component.errorStatus).toBeFalsy();
    expect(component.errorMsg).toBeFalsy();
  });
  it('should test search method', () => {
    component.paginationSettings.currentPage = 10;
    const fetchDataSpy = spyOn(component, 'fetchData');
    component.search();
    expect(component.paginationSettings.currentPage).toBe(1);
    expect(fetchDataSpy).toHaveBeenCalled();
  });
  it('should test fetchData method', () => {
    const data: ResponseModel = new ResponseModel();
    data.response = [new Search275Model()];
    data.pageSize = 10;
    data.sortColumn = 'attachmentId';
    data.pageNumber = 1;
    data.serviceDate = 10;
    data.attachType = 'jpg';
    data.totalNumberOfResults = 30;
    const serviceSpy = spyOn(searchService, 'search').and.callFake(() => {
      return new Observable(observer => {
        observer.next(data.response);
      });
    });
    component.fetchData();
    expect(serviceSpy).toHaveBeenCalled();
  });
  it('should test updateTable method', () => {
    const fetchDataSpy = spyOn(component, 'fetchData');
    component.updateTable();
    expect(fetchDataSpy).toHaveBeenCalled();
  });
  it('should test onDisplayAttachmentViewer method', () => {
    component.displayAttachmentViewer = false;
    const tempObj = { pathAddress: ['http://test.com/file.jpg'] };
    component.attachmentViewerComponent = {};
    component.attachmentViewerComponent.fileExtension = '';
    component.onDisplayAttachmentViewer(tempObj);
    expect(component.fileList).toContain('http://test.com/file.jpg');
    expect(component.selectedAttachment).toBe('http://test.com/file.jpg');
    expect(component.attachmentViewerComponent.fileExtension).toBe('JPG');
    expect(component.displayAttachmentViewer).toBe(true);
  });
});
