import { Injectable } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import { Response, Http } from '@angular/http';
import 'rxjs/add/operator/map';

import { environment } from '../../environments/environment';
import { UpdateRFAIRequestModel } from './rfai-submission.model';
@Injectable()
export class RfaiSubmissionService {
  constructor(private http: Http) {}
  getDetails(id) {
    // return Observable.create(observer => {
    //   observer.next(this.model);
    // });
    return this.http
      .get(`${environment.nodeserver}/rfai/viewSubmit/${id}`)
      .map((data: Response) => data.json());
  }

  updateRfai(body: UpdateRFAIRequestModel) {
    return this.http
      .post(`${environment.nodeserver}/rfai/updateRfai/`, body)
      .map((data: Response) => data.json());
  }
}
