import { Observable } from 'rxjs/Observable';
import { FormBuilder } from '@angular/forms';
import { RfaiLookupService } from '../rfai-lookup/rfai-lookup.service';
import { RfaiSubmissionService } from './rfai-submission.service';
import { RfaiSubmissionComponent } from './rfai-submission.component';
import { Observer } from 'rxjs/Observer';

describe('RfaiSubmissionComponent', () => {
  let fb: FormBuilder;
  let rfaiSubmissionService: RfaiSubmissionService;
  let rfaiLookupService: RfaiLookupService;
  let component: RfaiSubmissionComponent;

  beforeEach(() => {
    fb = new FormBuilder();
    rfaiSubmissionService = new RfaiSubmissionService(null);
    rfaiLookupService = new RfaiLookupService(null);
    component = new RfaiSubmissionComponent(
      fb,
      rfaiSubmissionService,
      rfaiLookupService
    );
  });

  it('should create the component', () => {
    expect(component).toBeTruthy();
  });

  it('should run ngOnInit successfully', () => {
    const getUserDataSpy = spyOn(component, 'getUserData').and.callFake(() => {
      sessionStorage.setItem(
        'viewSubmissionPermissions',
        '{"printRfai": "stuff1", "saveUpdates": "stuff2", "updateRfai": "stuff3"}'
      );

      component.viewSubmissionPermissions = JSON.parse(
        sessionStorage.getItem('viewSubmissionPermissions')
      );
    });

    // const getDetailsSpy = spyOn(component, 'getDetails').and.callFake( () => {
    //   console.log('details ran');
    // });

    const rfaiSubmissionSpy = spyOn(
      rfaiSubmissionService,
      'getDetails'
    ).and.callFake(() => {
      return Observable.create((observer: Observer<string>) => {
        observer.next('I am data');
      });
    });
    component.ngOnInit();
    expect(rfaiSubmissionSpy).toHaveBeenCalled();
  });

  it('should run getUserData with permissions', () => {
    const getUserDataSpy = spyOn(component, 'getUserData').and.callFake(() => {
      sessionStorage.setItem(
        'viewSubmissionPermissions',
        '{"printRfai": "stuff1", "saveUpdates": "stuff2", "updateRfai": "stuff3"}'
      );

      component.viewSubmissionPermissions = JSON.parse(
        sessionStorage.getItem('viewSubmissionPermissions')
      );
    });

    const rfaiSubmissionSpy = spyOn(
      rfaiSubmissionService,
      'getDetails'
    ).and.callFake(() => {
      return Observable.create((observer: Observer<string>) => {
        observer.next('I am data');
      });
    });
    component.ngOnInit();

    expect(component.disablePrint).toBeTruthy();
    expect(component.disableSave).toBeTruthy();
    expect(component.disableUpdate).toBeTruthy();
  });

  it('should run getUserData without permissions', () => {
    const getUserDataSpy = spyOn(component, 'getUserData').and.callFake(() => {
      sessionStorage.setItem('viewSubmissionPermissions', '{}');

      component.viewSubmissionPermissions = JSON.parse(
        sessionStorage.getItem('viewSubmissionPermissions')
      );
      console.log('view stuff', component.viewSubmissionPermissions);
      console.log(
        'view stuff2',
        sessionStorage.getItem('viewSubmissionPermissions')
      );
    });

    const rfaiSubmissionSpy = spyOn(
      rfaiSubmissionService,
      'getDetails'
    ).and.callFake(() => {
      return Observable.create((observer: Observer<string>) => {
        observer.next('I am data');
      });
    });
    component.ngOnInit();

    expect(component.disablePrint).toBeTruthy();
    expect(component.disableSave).toBeTruthy();
    expect(component.disableUpdate).toBeTruthy();
  });
});
