import {
  FormGroup,
  ValidationErrors,
  ValidatorFn,
  Validators
} from '@angular/forms';

export const atLeastOne = (validator: ValidatorFn) => (
  group: FormGroup
): ValidationErrors | null => {
  const hasAtLeastOne =
    group &&
    group.controls &&
    Object.keys(group.controls).some(k => !validator(group.controls[k]));

  // validator(group.controls[k]) --> null if no error --> false --> true
  //                              --> { required: true } if error --> true --> false
  // ! in front of the whole thing

  return hasAtLeastOne
    ? null
    : {
        atLeastOne: true
      };
};
