import { Injectable } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import { Response, Http } from '@angular/http';
import 'rxjs/add/operator/map';

import { environment } from '../../environments/environment';
import { RfaiInfoModel } from './rfai-form.model';

@Injectable()
export class RfaiFormService {
  constructor(private http: Http) {}
  populateInfo(id) {
    return this.http
      .get(`${environment.nodeserver}/rfai/populateClaim/${id}`)
      .map((data: Response) => data.json());
  }

  submitRfai(body: RfaiInfoModel) {
    return this.http
      .post(`${environment.nodeserver}/rfai/submit/`, body)
      .map((data: Response) => data.json());
  }

  getHccscCodes() {
    return this.http
      .post(`${environment.nodeserver}/rfai/getHccs`, ['Y'])
      .map((data: Response) => data.json());

    // return Observable.create(observer => {
    //   observer.next(this.hccscCodes);
    // });
  }

  getLoincCodes() {
    return this.http
      .post(`${environment.nodeserver}/rfai/getLoincCodes`, ['Y'])
      .map((data: Response) => data.json());
  }

  getLoincCodeModifiers() {
    return this.http
      .post(`${environment.nodeserver}/rfai/getLoincCodeModifiers`, ['Y'])
      .map((data: Response) => data.json());
  }
}
