import { Injectable } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import { Response, Http } from '@angular/http';
import { EmailModel } from './rfai-admin.model';
import 'rxjs/add/operator/map';

import { environment } from '../../environments/environment';
// import { HealthCareClaimStatusModel, EmailModel } from './rfai-admin.model';
@Injectable()
export class RfaiAdminService {
  constructor(private http: Http) {}

  postCodes(body) {
    return this.http
      .post(`${environment.nodeserver}/rfai/addCodes`, body)
      .map((data: Response) => data.json());
  }

  getHccscCode() {
    return this.http
      .post(`${environment.nodeserver}/rfai/getHccs`, ['Y', 'N'])
      .map((data: Response) => data.json());

    // return Observable.create(observer => {
    //   observer.next(this.hccscCodes);
    // });
  }

  getLoincCodes() {
    return this.http
      .post(`${environment.nodeserver}/rfai/getLoincCodes`, ['Y', 'N'])
      .map((data: Response) => data.json());
  }

  getLoincModifierCodes() {
    return this.http
      .post(`${environment.nodeserver}/rfai/getLoincCodeModifiers`, ['Y', 'N'])
      .map((data: Response) => data.json());
  }

  getEmailTemplates() {
    return this.http
      .get(`${environment.nodeserver}/rfai/getEmailTemplates`)
      .map((data: Response) => data.json());
  }

  submitEmailTemplate(body: EmailModel) {
    return this.http
      .put(`${environment.nodeserver}/rfai/submitEmailTempaltes`, body)
      .map((data: Response) => data.json());
  }
}
