import { Injectable } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import { Response, Http } from '@angular/http';
import 'rxjs/add/operator/map';

import { environment } from '../../environments/environment';

@Injectable()
export class AuthenticationService {
  constructor(private http: Http) {}
  authenticateAndGetUserInfo(userName) {
    userName = encodeURIComponent(userName);
    return this.http
      .get(`${environment.nodeserver}/login/userRoles/${userName}`)
      .map((data: Response) => data.json());
  }

  getDropDownInfo() {
    return this.http
      .get(`${environment.nodeserver}/login/login`)
      .map((data: Response) => data.json());
  }
  // test code for sso
  sso() {
    return this.http.get(`${environment.nodeserver}/sso/ssoTest`)
      .map(response => response.json())
  }
  getUserRoles(user) {
    return this.http.post(`${environment.nodeserver}/sso/getUserRoles`, user)
      .map((response: Response) => response.json())
  }
}
