import { Component, OnInit } from '@angular/core';
import { Location } from '@angular/common';
import { Router, ActivatedRoute } from '@angular/router';
import { FormBuilder, Validators, FormGroup } from '@angular/forms';
import { AuthenticationService } from './login.service';
import { DomSanitizer } from '@angular/platform-browser';
import { Sanitizer } from '@angular/core/src/security';

@Component({
  selector: 'app-login',
  templateUrl: './login.component.html',
  styleUrls: ['./login.component.scss']
})
export class LoginComponent implements OnInit {
  constructor(
    private router: Router,
    private location: Location,
    private fb: FormBuilder,
    private authenticationService: AuthenticationService,
    private sanitizer: DomSanitizer,
    private activatedRoute: ActivatedRoute
  ) {}
  userName = '';
  afterRedirectfromSso = false;
  loginForm: FormGroup;
  userInfo: any = {};
  errorMsg = '';
  errorStatus = false;
  safeUrl;
  sso;
  ssoUser;
  ngOnInit() {
    this.activatedRoute.params.subscribe(param => {
      this.ssoUser = encodeURIComponent(param['user']);
      //console.log('ssoUser ',this.ssoUser)
      if(this.ssoUser && this.ssoUser !== 'undefined'){
      this.authenticationService.getUserRoles({getNtname:this.ssoUser})
          .subscribe(data => {
              if (data.errorCode) {
              this.errorMsg = data.message;
              this.errorStatus = true;
            } 
            this.userInfo = data;
            this.errorMsg = '';
            this.errorStatus = false;
            this.redirect();
          });
        }
    })
          this.authenticationService.sso().subscribe(data => {
          this.sso = data;
        });
    this.safeUrl = this.sanitizer.bypassSecurityTrustUrl('https://URL       /ApplicationManager/Authenticate/Post');
    this.getDropDown();
    this.formInit();
  }

  formInit() {
    this.loginForm = this.fb.group({
      userName: [this.userName, Validators.required]
    });
  }

  getDropDown() {
    this.authenticationService.getDropDownInfo().subscribe(data => {
      this.userName = data;
    });
  }

  accept() {
    const user = this.loginForm.get('userName').value;
    this.getUsrInfo(user);
  }

  getUsrInfo(userName) {
    this.errorMsg = '';
    this.errorStatus = false;
    this.authenticationService
      .authenticateAndGetUserInfo(userName)
      .subscribe(data => {
        if (data.errorCode) {
          this.errorMsg = data.message;
          this.errorStatus = true;
        } else {
          this.userInfo = data;
          this.redirect();
        }
      });
  }

  redirect() {
    if (this.userInfo.userRoles !== undefined) {
      console.log(this.userInfo.userRoles);
      this.setSessionValues();
      if (
        this.userInfo.userRoles.some(
          data => data === 'ADMIN' || data === 'BASE_USER'
        )
      ) {
        this.router.navigate(['search275']);
      } else if (this.userInfo.userRoles.some(data => data === 'EWV')) {
        this.router.navigate(['ewvSearch']);
      } else {
        this.router.navigate(['/']);
      }
    }
  }

  setSessionValues() {
    sessionStorage.setItem('userInfo', JSON.stringify(this.userInfo));
    sessionStorage.setItem('role', this.userInfo.userRoles.length.toString());
    sessionStorage.setItem('userName', this.userInfo.userName);
    sessionStorage.setItem('lastLogin', this.userInfo.lastLogin);
    sessionStorage.setItem('userRole', JSON.stringify(this.userInfo.userRoles));

    sessionStorage.setItem(
      'permissions',
      JSON.stringify(this.userInfo.permissions)
    );
    sessionStorage.setItem(
      'additionalInformationPermissions',
      JSON.stringify(this.userInfo.permissions.additionalInformation)
    );

    sessionStorage.setItem(
      'lookupPermissions',
      JSON.stringify(this.userInfo.permissions.lookup)
    );
    sessionStorage.setItem(
      'viewSubmissionPermissions',
      JSON.stringify(this.userInfo.permissions.viewSubmission)
    );
    sessionStorage.setItem(
      'adminPermissions',
      JSON.stringify(this.userInfo.permissions.admin)
    );
    sessionStorage.setItem(
      'ewvSearch',
      JSON.stringify(this.userInfo.permissions.ewvSearch)
    );
  }
}
