import { Component, OnInit, Input } from '@angular/core';
import {
  TableColumnModel,
  PaginationSettings,
  TableSettings
} from '../../shared/table/table.component.model';

@Component({
  selector: 'app-professional',
  templateUrl: './professional.component.html',
  styleUrls: ['./professional.component.scss']
})
export class ProfessionalComponent implements OnInit {
  @Input() data: {}[];

  tableColumns: TableColumnModel[] = [
    new TableColumnModel('Line # ', 'lineNumber'),
    new TableColumnModel('Service From ', 'beginDateOfService'),
    new TableColumnModel('Service To ', 'dateOfService'),
    new TableColumnModel('POS ', 'pos'),
    new TableColumnModel('DX Pointer ', 'dxDtPointers'),
    new TableColumnModel('PROC/NDC ', 'procedureCode'),
    new TableColumnModel('Modifiers ', 'modifiers'),
    new TableColumnModel('Qty. / Type ', 'quantityOrType'),
    new TableColumnModel('Amount ', 'charge')
  ];

  tableInfoRows = [];
  loading = false;
  tableSettings: TableSettings = new TableSettings();
  paginationSettings: PaginationSettings = new PaginationSettings();
  ohiInfo;
  billingMiscellanous;
  constructor() {}

  ngOnInit() {
    this.tableSettings.pagination = false;

    this.tableInfoRows = this.data['serviceLinesInfo'];
    this.ohiInfo = this.data['ohiInfo'];
    this.billingMiscellanous = this.data['billingMiscellanous'];
    this.tableInfoRows = [
      {
        lineNumber: '1',
        serviceFrom: '01/01/2017',
        serviceTo: '01/01/2017',
        pos: '22',
        dxPointer: '1.2.3',
        procNdc: '12345',
        modifiers: 'AB99',
        quantityType: '99   UN',
        amount: '$999.99'
      },
      {
        lineNumber: '1',
        serviceFrom: '01/01/2017',
        serviceTo: '01/01/2017',
        pos: '22',
        dxPointer: '1.2.3',
        procNdc: '12345',
        modifiers: 'AB99',
        quantityType: '99   UN',
        amount: '$999.99'
      },
      {
        lineNumber: '1',
        serviceFrom: '01/01/2017',
        serviceTo: '01/01/2017',
        pos: '22',
        dxPointer: '1.2.3',
        procNdc: '12345',
        modifiers: 'AB99',
        quantityType: '99   UN',
        amount: '$999.99'
      }
    ];
  }
}
