import { Component, OnInit, Input } from '@angular/core';
import {
  TableColumnModel,
  TableSettings,
  PaginationSettings
} from '../../shared/table/table.component.model';

@Component({
  selector: 'app-institutional',
  templateUrl: './institutional.component.html',
  styleUrls: ['./institutional.component.scss']
})
export class InstitutionalComponent implements OnInit {
  @Input() data: {}[];
  // collapseState = true;

  tableColumns: TableColumnModel[] = [
    new TableColumnModel('Line # ', 'lineNumber'),
    new TableColumnModel('Service From ', 'beginDateOfService'),
    new TableColumnModel('Service To ', 'dateOfService'),
    new TableColumnModel('POS ', 'pos'),
    new TableColumnModel('DX Pointer ', 'dxDtPointers'),
    new TableColumnModel('PROC/NDC ', 'procedureCode'),
    new TableColumnModel('Modifiers ', 'modifiers'),
    new TableColumnModel('Qty. / Type ', 'quantityOrType'),
    new TableColumnModel('Amount ', 'charge')
  ];

  tableInfoRows = [];
  ohiInfo;
  billingMiscellanous;
  loading = false;
  tableSettings: TableSettings = new TableSettings();
  paginationSettings: PaginationSettings = new PaginationSettings();

  constructor() {}

  ngOnInit() {
    this.tableSettings.pagination = false;

    this.tableInfoRows = this.data['serviceLinesInfo'];
    this.ohiInfo = this.data['ohiInfo'];
    this.billingMiscellanous = this.data['billingMiscellanous'];
  }
}
