import { Component, OnInit, Input } from '@angular/core';
import { DentalComponent } from './dental/dental.component';
import { InstitutionalComponent } from './institutional/institutional.component';
import { ProfessionalComponent } from './professional/professional.component';
import { EwvService } from './ewv.service';

@Component({
  selector: 'app-ewv',
  templateUrl: './ewv.component.html',
  styleUrls: ['./ewv.component.scss']
})
export class EwvComponent implements OnInit {
  // 0 Institutional, 1 Professional, 2 Dental
  pageSelector = 'content';
  @Input() public collapseState: boolean = false;
  data;
  constructor(private ewvService: EwvService) {}

  ngOnInit() {
    // this.onType();
    // This is temporary
    // 200617203000952
    this.onInit();
    this.getStyle();
  }

  getStyle() {
    switch (this.pageSelector) {
      case (this.pageSelector = 'INSTITUTIONAL'):
        return 'inst';
      case (this.pageSelector = 'PROFESSIONAL'):
        return 'prof';
      case (this.pageSelector = 'DENTAL'):
        return 'dent';
      default:
        return 'inst';
    }
  }

  collapseFuctions(...state) {
    // Collapse Functionality Collapsing
    if (state[0] == 'expand') {
      this.collapseState = true;
    }
    // Collapse Functionality Not Collapsing
    if (state[0] == 'collapse') {
      this.collapseState = false;
    }
  }

  onInit() {
    this.ewvService.searchClaim().subscribe(data => {
      if (data) {
        console.log('this is data', data);
        this.data = this.ewvService.claimData;
        this.pageSelector = data.patientHeaderInfo.claimType;
      }
    });
  }
}
