import { EwvComponent } from './ewv.component';
import { EwvService } from './ewv.service';
import { Observable } from 'rxjs/Observable';
import { Observer } from 'rxjs/Observer';

describe('EwvComponent', () => {
  let ewvService: EwvService;
  let component: EwvComponent;

  beforeEach(() => {
    ewvService = new EwvService(null);
    component = new EwvComponent(ewvService);
  });

  it('should be created', () => {
    expect(component).toBeTruthy();
  });

  it('should run ngOnInit', () => {
    const onInitSpy = spyOn(component, 'onInit');
    const getStyleSpy = spyOn(component, 'getStyle');

    component.ngOnInit();

    expect(onInitSpy).toHaveBeenCalled();
    expect(getStyleSpy).toHaveBeenCalled();
  });

  it('should run getStyle method with "INSTITUTIONAL"', () => {
    component.pageSelector = 'INSTITUTIONAL';

    const returnedValue = component.getStyle();

    expect(returnedValue).toEqual('inst');
  });

  it('should run getStyle method with "PROFESSIONAL"', () => {
    component.pageSelector = 'PROFESSIONAL';

    const returnedValue = component.getStyle();

    expect(returnedValue).toEqual('prof');
  });

  it('should run getStyle method with "DENTAL"', () => {
    component.pageSelector = 'DENTAL';

    const returnedValue = component.getStyle();

    expect(returnedValue).toEqual('dent');
  });

  it('should run getStyle method with default case value', () => {
    component.pageSelector = 'NOTHING';

    const returnedValue = component.getStyle();

    expect(returnedValue).toEqual('inst');
  });

  it('should run collapseFuctions method with state set to "expand"', () => {
    component.collapseState = false;

    component.collapseFuctions(['expand']);

    expect(component.collapseState).toEqual(true);
  });

  it('should run collapseFuctions method with state set to "collapse"', () => {
    component.collapseState = false;

    component.collapseFuctions(['collapse']);

    expect(component.collapseState).toEqual(false);
  });

  it('should run onInit method', () => {
    const searchClaimSpy = spyOn(ewvService, 'searchClaim').and.callFake(
      () =>
        new Observable((observer: Observer<{}>) =>
          observer.next({ patientHeaderInfo: { claimType: 'iamtype' } })
        )
    );

    component.onInit();

    expect(component.pageSelector).toEqual('iamtype');
  });
});
