import { Component, OnInit, Input } from '@angular/core';
import { TableColumnModel, TableSettings, PaginationSettings } from '../../../shared/table/table.component.model';



@Component({
  selector: 'app-dental-detail',
  templateUrl: './dental-detail.component.html',
  styleUrls: ['./dental-detail.component.scss']
})
export class DentalDetailComponent implements OnInit {
  collapseState = true;
    
  @Input() data: {}[];


  tableColumns: TableColumnModel[] = [
    new TableColumnModel('Line # ', 'lineNumber'),
    new TableColumnModel('Service From ', 'beginDateOfService'),
    new TableColumnModel('Service To ', 'dateOfService'),
    new TableColumnModel('POS ', 'pos'),
    new TableColumnModel('DX Pointer ', 'dxDtPointers'),
    new TableColumnModel('PROC/NDC ', 'procedureCode'),
    new TableColumnModel('Modifiers ', 'modifiers'),
    new TableColumnModel('Qty. / Type ', 'quantityOrType'),
    new TableColumnModel('Amount ', 'charge')
  ];

  primaryClaimAdjustmentsTableColumns: TableColumnModel[] = [
    new TableColumnModel('OHI Paid Amt. ', 'ohiPaidAmt'),
    new TableColumnModel('Total Non-Covered ', 'totalNonCovered'),
    new TableColumnModel('Qty. ', 'qty'),
    new TableColumnModel('Adj. ', 'adj'),
    new TableColumnModel('Adj. Amt. ', 'adjAmt'),
  ];

  secondaryClaimAdjustmentsTableColumns: TableColumnModel[] = [
    new TableColumnModel('OHI Paid Amt. ', 'ohiPaidAmt'),
    new TableColumnModel('Total Non-Covered ', 'totalNonCovered'),
    new TableColumnModel('Qty. ', 'qty'),
    new TableColumnModel('Adj. ', 'adj'),
    new TableColumnModel('Adj. Amt. ', 'adjAmt'),
  ];

  tableInfoRows = [];
  primaryClaimAdjustmentsTableInfoRows = [];
  secondaryClaimAdjustmentsTableInfoRows = [];
  loading = false;
  tableSettings: TableSettings = new TableSettings();
  paginationSettings: PaginationSettings = new PaginationSettings();

  constructor() { }

  

  ngOnInit() {
    this.tableSettings.pagination = false;

    this.tableInfoRows = this.data['serviceLinesInfo'];

    console.log('dental detail\'s data:', this.data);

    this.primaryClaimAdjustmentsTableInfoRows = [
      { 
        ohiPaidAmt: '$999.99', 
        totalNonCovered: '$99.99', 
        qty: '99', 
        adj: 'AB12', 
        adjAmt: '999.99'
      },
      { 
        ohiPaidAmt: '$999.99', 
        totalNonCovered: '$99.99', 
        qty: '99', 
        adj: 'AB12', 
        adjAmt: '999.99'
      },
      { 
        ohiPaidAmt: '$999.99', 
        totalNonCovered: '$99.99', 
        qty: '99', 
        adj: 'AB12', 
        adjAmt: '999.99'
      },
      { 
        ohiPaidAmt: '$999.99', 
        totalNonCovered: '$99.99', 
        qty: '99', 
        adj: 'AB12', 
        adjAmt: '999.99'
      },
    ];

    this.secondaryClaimAdjustmentsTableInfoRows = [
      { 
        ohiPaidAmt: '$999.99', 
        totalNonCovered: '$99.99', 
        qty: '99', 
        adj: 'AB12', 
        adjAmt: '999.99'
      },
      { 
        ohiPaidAmt: '$999.99', 
        totalNonCovered: '$99.99', 
        qty: '99', 
        adj: 'AB12', 
        adjAmt: '999.99'
      }
    ];

  }
}
