import { Component, OnInit } from '@angular/core';

import {
  TableColumnModel,
  TableSettings,
  PaginationSettings
} from '../../shared/table/table.component.model';

@Component({
  selector: 'app-billing-information',
  templateUrl: './billing-information.component.html',
  styleUrls: ['./billing-information.component.scss']
})
export class BillingInformationComponent implements OnInit {

  tableColumns: TableColumnModel[] = [
    new TableColumnModel('Line # ', 'lineNumber'),
    new TableColumnModel('Service From ', 'serviceFrom'),
    new TableColumnModel('Service To ', 'serviceTo'),
    new TableColumnModel('POS ', 'pos'),
    new TableColumnModel('DX Pointer ', 'dxPointer'),
    new TableColumnModel('PROC/NDC ', 'procNdc'),
    new TableColumnModel('Modifiers ', 'modifiers'),
    new TableColumnModel('Qty. / Type ', 'quantityType'),
    new TableColumnModel('Amount ', 'amount')
  ];

  tableInfoRows = [];
  loading = false;
  tableSettings: TableSettings = new TableSettings();
  paginationSettings: PaginationSettings = new PaginationSettings();

  constructor() { }

  ngOnInit() {
    this.tableSettings.pagination = false;

    this.tableInfoRows = [
      { 
        lineNumber: '1', 
        serviceFrom: '01/01/2017', 
        serviceTo: '01/01/2017', 
        pos: '22', 
        dxPointer: '1.2.3', 
        procNdc: '12345',
        modifiers: 'AB99',
        quantityType: '99   UN',
        amount: '$999.99'
      },
      { 
        lineNumber: '1', 
        serviceFrom: '01/01/2017', 
        serviceTo: '01/01/2017', 
        pos: '22', 
        dxPointer: '1.2.3', 
        procNdc: '12345',
        modifiers: 'AB99',
        quantityType: '99   UN',
        amount: '$999.99'
      },
      { 
        lineNumber: '1', 
        serviceFrom: '01/01/2017', 
        serviceTo: '01/01/2017', 
        pos: '22', 
        dxPointer: '1.2.3', 
        procNdc: '12345',
        modifiers: 'AB99',
        quantityType: '99   UN',
        amount: '$999.99'
      }    
    ];
  }

}
