import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import {
  FormControl,
  FormGroup,
  FormBuilder,
  Validators
} from '@angular/forms';

import { EwvService } from '../ewv/ewv.service';

@Component({
  selector: 'app-ewv-search',
  templateUrl: './ewv-search.component.html',
  styleUrls: ['./ewv-search.component.scss']
})
export class EwvSearchComponent implements OnInit {
  form: FormGroup;
  pdiSearchParam;
  constructor(
    private router: Router,
    private ewvService: EwvService,
    private fb: FormBuilder
  ) {}

  ngOnInit() {
    this.formInit();
  }

  formInit() {
    this.form = this.fb.group({
      pdiSearchParam: [
        this.pdiSearchParam,
        Validators.compose([
          Validators.pattern('[0-9]*'),
          Validators.minLength(15)
        ])
      ]
    });
  }

  onSearch() {
    if (this.pdiSearchParam != '') {
      this.ewvService.setClaim(this.pdiSearchParam);
      this.ewvService.searchClaim().subscribe(data => {
        if (data.patientHeaderInfo) {
          this.ewvService.claimData = data;
          this.router.navigate(['ewv']);
        } else {
          // Placeholder for error message
          console.log('no data');
        }
      });
    }
  }
}
