import { ArsReportsComponent } from './ars-reports.component';
import { ArsReportsService } from './ars-reports.service';
import { ScriptService } from '../shared/scriptLoader/script.service';
import { FormBuilder } from '@angular/forms';
import { Observable } from 'rxjs/Observable';
import { PaginationSettings } from '../shared/table/table.component.model';
import {
  ARSReportResponse,
  ARSReportsModelReqRangeDate
} from './ars-reports.model';

describe('ArsReportsComponent', () => {
  let fb: FormBuilder;
  let arsReportsService: ArsReportsService;
  let script: ScriptService;
  let component: ArsReportsComponent;

  beforeEach(() => {
    fb = new FormBuilder();
    arsReportsService = new ArsReportsService(null);
    script = new ScriptService();
    component = new ArsReportsComponent(fb, arsReportsService, script);
  });

  it('should be created', () => {
    expect(component).toBeTruthy();
  });

  it('should test ngOnInit', () => {
    const formInitSpy = spyOn(component, 'formInit');
    const setDefaultDateSpy = spyOn(component, 'setDefaultDate');
    component.ngOnInit();

    expect(formInitSpy).toHaveBeenCalled();
    expect(setDefaultDateSpy).toHaveBeenCalled();
  });

  it('should test setDefaultDate', () => {
    component.startDate.nativeElement = { value: 1 };
    component.endDate.nativeElement = { value: 1 };

    component.formInit();
    component.setDefaultDate();

    const date = component.form.get('startDate').value;

    expect(component.form.get('endDate').value).toEqual(date);
    expect(component.startDate.nativeElement.value).toEqual(date);
    expect(component.arsReportsModelReqRangeDate.endDate).toEqual(date);
  });

  it('should test formInit with "last24Hours" equal to "true"', () => {
    component.startDate.nativeElement = { value: 1 };
    component.endDate.nativeElement = { value: 1 };
    // component.arsReportsModelReqRangeDate.last24Hours = true;

    component.formInit();

    expect(component.form).toBeTruthy();
  });

  // it('should test formInit with "last24Hours" equal to "false"', () => {
  //   component.startDate.nativeElement = { value: 1 };
  //   component.endDate.nativeElement = { value: 1 };
  //   component.arsReportsModelReqRangeDate.last24Hours = false;

  //   component.formInit();

  //   expect(component.form).toBeTruthy();
  // });

  // it('should test formInit with "last24Hours" equal to "false"', () => {
  //   component.startDate.nativeElement = { value: 1 };
  //   component.endDate.nativeElement = { value: 1 };
  //   // component.arsReportsModelReqRangeDate.last24Hours = false;

  //   component.formInit();

  //   expect(component.form).toBeTruthy();
  // });

  it('should test fetchData method with error', () => {
    const generateReportRangeSpy = spyOn(
      arsReportsService,
      'generateReportRange'
    ).and.callFake(
      () => new Observable(observer => observer.next({ errorCode: true }))
    );
    component.fetchData();

    expect(component.errorStatus).toBeTruthy();
  });

  it('should test fetchData method without error', () => {
    const generateReportRangeSpy = spyOn(
      arsReportsService,
      'generateReportRange'
    ).and.callFake(
      () => new Observable(observer => observer.next(new ARSReportResponse()))
    );
    component.fetchData();

    expect(component.response).toBeDefined();
  });

  it('should test fetchData method without error', () => {
    const generateReportRangeSpy = spyOn(
      arsReportsService,
      'generateReportRange'
    ).and.callFake(
      () => new Observable(observer => observer.next(new ARSReportResponse()))
    );
    component.fetchData();

    expect(component.response).toBeDefined();
  });

  it('should test resetForm method', () => {
    component.startDate.nativeElement = { value: 'something' };
    component.endDate.nativeElement = { value: 'something' };
    const setDefaultDateSpy = spyOn(component, 'setDefaultDate');

    component.resetAttachReports();

    expect(component.startDate.nativeElement.value).toEqual('');
    expect(component.showResults).toBeFalsy();
    expect(component.errorMsg).toEqual('');
    expect(setDefaultDateSpy).toHaveBeenCalled();
  });

  it('should test datesValidator method if statement', () => {
    component.startDate = { nativeElement: { value: '1234567890' } };
    component.endDate = { nativeElement: { value: '1234567890' } };
    component.formInit();

    component.datesValidator();

    expect(component.form.get('startDate').value).toEqual('1234567890');
    expect(component.form.get('endDate').value).toEqual('1234567890');
  });

  it('should test datesValidator method else statement', () => {
    component.startDate = { nativeElement: { value: '1' } };
    component.endDate = { nativeElement: { value: '2' } };
    component.validDateRange = false;

    component.datesValidator();

    expect(component.validDateRange).toBeTruthy();
  });

  it('should test updateTable method', () => {
    const fetchDataSpy = spyOn(component, 'fetchData');

    component.updateTable();

    expect(fetchDataSpy).toHaveBeenCalled();
  });
});
