import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';
import { AppRoutingModule } from './app-routing.module';
import { HttpModule } from '@angular/http';
import { AppComponent } from './app.component';
import { LoginComponent } from './login/login.component';
import { RouterModule } from '@angular/router';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { RfaiFormComponent } from './rfai-form/rfai-form.component';
import { RfaiFormService } from './rfai-form/rfai-form.service';
import { RfaiLookupService } from './rfai-lookup/rfai-lookup.service';
import { ModalComponent } from './shared/modal/modal.component';
import { RfaiLookupComponent } from './rfai-lookup/rfai-lookup.component';
import { TableComponent } from './shared/table/table.component';
import { PaginationComponent } from './shared/table/pagination/pagination.component';
import { TableService } from './shared/table/table.service';
import { RfaiSubmissionComponent } from './rfai-submission/rfai-submission.component';
import { RfaiSubmissionService } from './rfai-submission/rfai-submission.service';
import { RfaiAdminComponent } from './rfai-admin/rfai-admin.component';
import { RfaiAdminService } from './rfai-admin/rfai-admin.service';
import { AuthenticationService } from './login/login.service';
import { HeaderComponent } from './shared/header/header.component';
import { NavigationComponent } from './shared/navigation/navigation.component';
import { AuthRouteActivatorService } from './shared/auth-route-activator.service';
import { SpinnerComponent } from './shared/spinner/spinner.component';
import { MessagesComponent } from './shared/messages/messages.component';
import { WindowRefService } from './window-ref.service';
import { AutofocusDirective } from './shared/directive/autofocus.directive';
import { Search275Component } from './search275/search275.component';
import { Search275Service } from './search275/search275.service';
import { EwvSearchComponent } from './ewv-search/ewv-search.component';
import { AttachmentViewerComponent } from './shared/attachment-viewer/attachment-viewer.component';
import { AttachmentViewerService } from './shared/attachment-viewer/attachment-viewer.service';
import { FooterComponent } from './shared/footer/footer.component';
import { PdfViewerModule } from 'ng2-pdf-viewer';
import { UserAdminComponent } from './user-admin/user-admin.component';
import { ArsReportsComponent } from './ars-reports/ars-reports.component';
import { ArsReportsService } from './ars-reports/ars-reports.service';
import { UserAdminService } from './user-admin/user-admin.service';
import { EwvComponent } from './ewv/ewv.component';
import { InstitutionalComponent } from './ewv/institutional/institutional.component';
import { ProfessionalComponent } from './ewv/professional/professional.component';
import { DentalComponent } from './ewv/dental/dental.component';
import { ArsStorageComponent } from './ars-reports/ars-storage/ars-storage.component';
import { ArsStorageService } from './ars-reports/ars-storage/ars-storage.service';
import { EwvService } from './ewv/ewv.service';
import { BillingInformationComponent } from './ewv/billing-information/billing-information.component';
import { OtherHealthInformationComponent } from './ewv/other-health-information/other-health-information.component';
import { SsoRedirectComponent } from './login/sso-redirect.component';
import { InstitutionalDetailComponent } from './ewv/institutional/institutional-detail/institutional-detail.component';
import { DentalDetailComponent } from './ewv/dental/dental-detail/dental-detail.component';
@NgModule({
  declarations: [
    AppComponent,
    LoginComponent,
    ModalComponent,
    RfaiFormComponent,
    RfaiLookupComponent,
    TableComponent,
    PaginationComponent,
    RfaiSubmissionComponent,
    RfaiAdminComponent,
    HeaderComponent,
    NavigationComponent,
    SpinnerComponent,
    MessagesComponent,
    AutofocusDirective,
    Search275Component,
    EwvSearchComponent,
    AttachmentViewerComponent,
    FooterComponent,
    UserAdminComponent,
    ArsReportsComponent,
    ProfessionalComponent,
    EwvComponent,
    InstitutionalComponent,
    DentalComponent,
    ArsStorageComponent,
    BillingInformationComponent,
    OtherHealthInformationComponent,
    SsoRedirectComponent,
    DentalDetailComponent,
    InstitutionalDetailComponent
  ],

  imports: [
    BrowserModule,
    FormsModule,
    HttpModule,
    AppRoutingModule,
    RouterModule,
    ReactiveFormsModule,
    PdfViewerModule
  ],

  providers: [
    RfaiFormService,
    RfaiLookupService,
    TableService,
    RfaiSubmissionService,
    RfaiAdminService,
    AuthenticationService,
    AuthRouteActivatorService,
    WindowRefService,
    Search275Service,
    ArsReportsService,
    UserAdminService,
    AttachmentViewerService,
    EwvService,
    ArsStorageService
  ],
  bootstrap: [AppComponent]
})
export class AppModule {}
