import { Component, OnInit, OnDestroy } from '@angular/core';
import { Router, NavigationEnd } from '@angular/router';
import { Subscription } from 'rxjs/Subscription';

import { WindowRefService } from './window-ref.service';

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.scss']
})
export class AppComponent implements OnInit, OnDestroy {
  title = 'Attachment Reetrieval System';
  subscription: Subscription;
  constructor(private router: Router, private windowRef: WindowRefService) {}
  ngOnInit() {
    this.subscription = this.router.events.subscribe(event => {
      if (!(event instanceof NavigationEnd)) {
        return;
      }
      this.windowRef.nativeWindow.scrollTo(0, 0);
    });
  }
  ngOnDestroy() {
    this.subscription.unsubscribe();
  }
}
