import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { LoginComponent } from './login/login.component';
import { RfaiFormComponent } from './rfai-form/rfai-form.component';
import { RfaiLookupComponent } from './rfai-lookup/rfai-lookup.component';
import { RfaiSubmissionComponent } from './rfai-submission/rfai-submission.component';
import { RfaiAdminComponent } from './rfai-admin/rfai-admin.component';
import { AuthRouteActivatorService } from './shared/auth-route-activator.service';
import { Search275Component } from './search275/search275.component';
import { EwvSearchComponent } from './ewv-search/ewv-search.component';
import { AttachmentViewerComponent } from './shared/attachment-viewer/attachment-viewer.component';
import { UserAdminComponent } from './user-admin/user-admin.component';
import { ArsReportsComponent } from './ars-reports/ars-reports.component';
import { EwvComponent } from './ewv/ewv.component';
import { InstitutionalComponent } from './ewv/institutional/institutional.component';
import { DentalComponent } from './ewv/dental/dental.component';
import { ProfessionalComponent } from './ewv/professional/professional.component';
import { SsoRedirectComponent } from './login/sso-redirect.component';
// import { XmlViewerComponent } from './xml-viewer/xml-viewer.component';

const routes: Routes = [
  { path: '', component: LoginComponent, pathMatch: 'full' },
  { path: 'login', component: LoginComponent },
  { path: 'login/:user', component: LoginComponent},

  {
    path: 'additionalInformation',
    component: RfaiFormComponent
  },
  {
    path: 'lookup',
    component: RfaiLookupComponent
  },
  {
    path: 'viewSubmission',
    component: RfaiSubmissionComponent
  },
  {
    path: 'rfaiAdmin',
    component: RfaiAdminComponent
  },
  {
    path: 'search275',
    component: Search275Component,
    // canActivate: [AuthRouteActivatorService] commented out for testing
  },
  {
    path: 'ewvSearch',
    component: EwvSearchComponent,
    canActivate: [AuthRouteActivatorService]
  },
  {
    path: 'attachmentViewer',
    component: AttachmentViewerComponent
  },
  {
    path: 'arsReports',
    component: ArsReportsComponent,
    canActivate: [AuthRouteActivatorService]
  },
  // {
  //   path: 'xmlViewer',
  //   component: XmlViewerComponent
  // },
  {
    path: 'ewv',
    component: EwvComponent
  },
  {
    path: 'ewvProfessional',
    component: ProfessionalComponent
  },
  {
    path: 'ewvInstitutional',
    component: InstitutionalComponent
  },
  {
    path: 'ewvDental',
    component: DentalComponent
  },
  {
    path: 'userAdmin',
    component: UserAdminComponent,
    canActivate: [AuthRouteActivatorService]
  },
  {
  path: 'redirect',
  component: SsoRedirectComponent
  }
];

@NgModule({
  imports: [RouterModule.forRoot(routes)],
  providers: [AuthRouteActivatorService],
  exports: [RouterModule]
})
export class AppRoutingModule {}
