const express = require('express');
const path = require('path');
const http = require('http');
const https = require('https');
const fs = require('fs');
const bodyParser = require('body-parser');
const app = express();

// Added to read the endPointURI from the properties file
const dotenv = require('dotenv').config();
// Change!!!
app.use(bodyParser.json());
app.use(
  bodyParser.urlencoded({
    extended: false
  })
);
app.use(express.static(path.join(__dirname, './dist')));
// Below is REST Caching fix for IE11
app.use((req, res, next) => {
  res.set({
    'Access-Control-Allow-Origin': '*',
    'Access-Control-Allow-Methods': 'GET,POST,PUT,DELETE,OPTIONS',
    'Access-Control-Allow-Headers':
      'Origin, X-Requested-With, Content-Type, Accept',
    'Cache-Control': 'no-cache, no-store, private, must-revalidate',
    Expires: '-1',
    Pragma: 'no-cache'
  });
  next();
});

// at this point all we need is the login route
const ewv = require('./ars-app-server/server/routes/ewv/ewv');
const login = require('./ars-app-server/server/routes/login/login');
const rfai = require('./ars-app-server/server/routes/rfai/rfai');
const lookup = require('./ars-app-server/server/routes/lookup/lookup');
const attachment = require('./ars-app-server/server/routes/275/275_attachment');
const arsReports = require('./ars-app-server/server/routes/reports/arsReports');
const userDetails = require('./ars-app-server/server/routes/userAdmin/userAdmin');
const sso = require('./ars-app-server/server/auth/sso');
const dashboard = require('./ars-app-server/server/routes/reports/dashboard');

//Configure the SSL Certificates received from the Certifying Authority
const  httpsOptions = {
  cert:fs.readFileSync(path.join(__dirname,'ssl-certs/qa','vaausappcae801.crt')),
  key:fs.readFileSync(path.join(__dirname,'ssl-certs/qa','vaausappcae801.key'))
}

app.use('/login', login);
app.use('/rfai', rfai);
app.use('/ewv', ewv);
app.use('/lookup', lookup);
app.use('/attachment', attachment);
app.use('/arsReports', arsReports);
app.use('/userDetails', userDetails);
app.use('/dashboard', dashboard);

// test code for sso //
app.use('/sso', sso);

// end of test code //

const port = process.env.PORT || '3003';
app.set('port', port);

app.get('*', (req, res) => {
  res.sendFile(path.join(__dirname, './dist/index.html'));
});

https.createServer( httpsOptions,app
).listen(port, function() {
  console.log(
		'API running on port ' + port + ' - Using endpoint ' +
			process.env.END_POINT_BASE_URI
	)
});
