// Karma configuration file, see link for more information
// https://karma-runner.github.io/1.0/config/configuration-file.html

module.exports = function(config) {
  config.set({
    basePath: '',
    frameworks: ['jasmine', '@angular/cli'],
    plugins: [
      require('karma-jasmine'),
      //require('karma-IE-launcher'),
      require('karma-chrome-launcher'),
      require('karma-jasmine-html-reporter'),
      require('karma-coverage-istanbul-reporter'),
      require('karma-junit-reporter'),
      require('karma-coverage'),
      require('karma-jenkins-reporter'),
      require('@angular/cli/plugins/karma')
    ],
    client: {
      clearContext: false // leave Jasmine Spec Runner output visible in browser
    },
    coverageIstanbulReporter: {
      reports: ['html', 'lcovonly'],
      fixWebpackSourcePaths: true
    },
    angularCli: {
      //environment: 'dev'
      environment: 'ci'
    },
    reporters: ['progress', 'kjhtml', 'junit', 'coverage'],
    port: 9876,
    colors: true,
    logLevel: config.LOG_INFO,
    autoWatch: false,
    browsers: ['ChromeHeadless'],
    singleRun: false,
    junitReporter    : {
        outputDir : 'target/surefire-reports/'
    },
    coverageReporter : {
        type : 'cobertura',
        dir  : 'target/coverage-reports/'
    },
    customLaunchers: {
  	  ChromeHeadless: {
  	    base: 'Chrome',
  	    flags: [
  	      '--headless',
  	      '--disable-gpu',
  	      // Without a remote debugging port, Google Chrome exits immediately.
  	      '--remote-debugging-port=PORT',
  	    ],
  	  }
  	}
  });
};
