const xml2js = require('xml2js');
const fs = require('fs');

const xmlParser = new xml2js.Parser();
const xmlToJson = (path, response) => {
  fs.readFile(path, { encoding: 'utf8' }, (err, data) => {
    if (err) {
      return () => {
        console.error('Unable to read from file path. ', err);
      };
    }
    xmlParser.parseString(data, (err, parsedData) => {
      console.log('parsedData', parsedData);
      if (err) {
        return response.status(500).json('Server error');
      }
      return response.status(200).json(parsedData);
    });
  });
};

module.exports = xmlToJson;
