const fs = require('fs');
const getFiles = (dir, fileList) => {
  fileList = fileList || [];
  const files = fs.readdirSync(dir);
  for (let file in files) {
    if (!files.hasOwnProperty(file)) {
      continue;
    }
    let fileName = `${dir}/${files[file]}`;
    if (fs.statSync(fileName).isDirectory()) {
      getFiles(fileName, fileList);
    } else {
      fileList.push(fileName);
    }
  }
  return fileList.map(file => file.match(/(src)(.*)/)[2]);
};

module.exports = getFiles;
