const express = require('express');
const router = express.Router();
const rest = require('../../rest/rest');

router.get('/userInfo/:userName', (req, res) => {
  const userName = encodeURIComponent(req.params.userName);
  const id = req.params.id;
  rest
    .getResource(
      process.env.END_POINT_BASE_URI +
        process.env.GET_USERDETAILS +
        '/' +
        userName
    )
    .then(data => {
      if (data) {
        res.status(200).json(data);
      } else {
        res.status(500).json(data);
      }
    })
    .catch(error => {
      console.log('Reports getStations error ', error);
    });
});

router.post('/userInfo', (req, res) => {
  rest
    .postResource(
      process.env.END_POINT_BASE_URI + process.env.LIST_ALLUSERS + '/',
      req.body
    )
    .then(data => {
      if (data) {
        res.status(200).json(data);
      } else {
        res.status(500).json(data);
      }
    })
    .catch(error => {
      console.log('Reports getStations error ', error);
    });
});
//rest call to delete user
router.get('/deleteUserInfo/:userId', (req, res) => {
  const userId = req.params.userId;
  // const id = req.params.id;
  rest
    .getResource(
      process.env.END_POINT_BASE_URI + process.env.DELETE_USER + '/' + userId
    )
    .then(data => {
      console.log(
        process.env.END_POINT_BASE_URI + process.env.DELETE_USER + '/' + userId
      );
      if (data) {
        console.log(data);
        res.status(200).json(data);
      } else {
        res.status(500).json(data);
      }
    })
    .catch(error => {
      console.log('Reports getStations error ', error);
    });
});

//Rest Call for Create USer
router.post('/createUser', (req, res) => {
  rest
    .postResource(
      process.env.END_POINT_BASE_URI + process.env.CREATE_USER + '/',
      req.body
    )
    .then(data => {
      if (data) {
        res.status(200).json(data);
      } else {
        res.status(500).json(data);
      }
    })
    .catch(error => {
      console.log('Reports getStations error ', error);
    });
});

//Rest Call for Edit USer
router.post('/editUser', (req, res) => {
  rest
    .postResource(
      process.env.END_POINT_BASE_URI + process.env.EDIT_USER + '/',
      req.body
    )
    .then(data => {
      if (data) {
        res.status(200).json(data);
      } else {
        res.status(500).json(data);
      }
    })
    .catch(error => {
      console.log('Reports getStations error ', error);
    });
});
module.exports = router;
